/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2.util;

import net.william278.velocitab.libraries.mvel2.ast.ASTNode;
import net.william278.velocitab.libraries.mvel2.util.ASTIterator;

public class ASTLinkedList
implements ASTIterator {
    private ASTNode firstASTNode;
    private ASTNode current;
    private ASTNode last;
    private int size;

    public ASTLinkedList() {
    }

    public ASTLinkedList(ASTIterator iter) {
        this.current = this.firstASTNode = iter.firstNode();
    }

    public ASTLinkedList(ASTNode firstASTNode) {
        this.current = this.firstASTNode = firstASTNode;
    }

    public ASTLinkedList(ASTNode firstASTNode, int size) {
        this.current = this.firstASTNode = firstASTNode;
        this.size = size;
    }

    @Override
    public void addTokenNode(ASTNode astNode) {
        ++this.size;
        if (this.firstASTNode == null) {
            this.firstASTNode = this.current = astNode;
        } else {
            this.current = this.current.nextASTNode = astNode;
            this.last = this.current.nextASTNode;
        }
    }

    @Override
    public void addTokenNode(ASTNode astNode, ASTNode token2) {
        this.size += 2;
        if (this.firstASTNode == null) {
            this.firstASTNode = astNode;
            this.current = astNode.nextASTNode = token2;
            this.last = astNode.nextASTNode;
        } else {
            this.current.nextASTNode = astNode;
            this.current = astNode.nextASTNode = token2;
            this.last = astNode.nextASTNode;
        }
    }

    @Override
    public ASTNode firstNode() {
        return this.firstASTNode;
    }

    public boolean isSingleNode() {
        return this.size == 1 || this.size == 2 && this.firstASTNode.fields == -1;
    }

    public ASTNode firstNonSymbol() {
        if (this.firstASTNode.fields == -1) {
            return this.firstASTNode.nextASTNode;
        }
        return this.firstASTNode;
    }

    @Override
    public void reset() {
        this.current = this.firstASTNode;
    }

    @Override
    public boolean hasMoreNodes() {
        return this.current != null;
    }

    @Override
    public ASTNode nextNode() {
        if (this.current == null) {
            return null;
        }
        try {
            ASTNode aSTNode = this.current;
            return aSTNode;
        }
        finally {
            this.last = this.current;
            this.current = this.current.nextASTNode;
        }
    }

    @Override
    public void skipNode() {
        if (this.current != null) {
            this.current = this.current.nextASTNode;
        }
    }

    @Override
    public ASTNode peekNext() {
        if (this.current != null && this.current.nextASTNode != null) {
            return this.current.nextASTNode;
        }
        return null;
    }

    @Override
    public ASTNode peekNode() {
        if (this.current == null) {
            return null;
        }
        return this.current;
    }

    public void removeToken() {
        if (this.current != null) {
            this.current = this.current.nextASTNode;
        }
    }

    @Override
    public ASTNode peekLast() {
        return this.last;
    }

    @Override
    public ASTNode nodesBack(int offset) {
        throw new RuntimeException("unimplemented");
    }

    @Override
    public ASTNode nodesAhead(int offset) {
        if (this.current == null) {
            return null;
        }
        ASTNode cursor = null;
        for (int i = 0; i < offset; ++i) {
            cursor = this.current.nextASTNode;
            if (cursor != null) continue;
            return null;
        }
        return cursor;
    }

    @Override
    public void back() {
        this.current = this.last;
    }

    @Override
    public String showNodeChain() {
        throw new RuntimeException("unimplemented");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int index() {
        return -1;
    }

    public void setCurrentNode(ASTNode node) {
        this.current = node;
    }

    @Override
    public void finish() {
        this.reset();
        ASTNode last = null;
        while (this.hasMoreNodes()) {
            ASTNode curr = this.nextNode();
            if (curr.isDiscard()) {
                if (last == null) {
                    last = this.firstASTNode = this.nextNode();
                    continue;
                }
                last.nextASTNode = this.nextNode();
                continue;
            }
            if (!this.hasMoreNodes()) break;
            last = curr;
        }
        this.last = last;
        this.reset();
    }
}

