/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.toilet.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import net.william278.velocitab.libraries.annotations.NotNull;

public interface Flusher {
    @NotNull
    default public String uploadDump(@NotNull String content, @NotNull String bytebucketUrl, @NotNull String proj) throws IOException {
        HttpURLConnection connection = this.createConnection(bytebucketUrl, proj);
        byte[] compressedContent = this.compressContent(content);
        this.sendRequestData(connection, compressedContent);
        int responseCode = connection.getResponseCode();
        this.checkResponseCode(responseCode);
        String locationHeader = this.getLocationHeader(connection);
        connection.disconnect();
        return locationHeader;
    }

    @NotNull
    private HttpURLConnection createConnection(@NotNull String bytebucketUrl, @NotNull String proj) throws IOException {
        URL url = new URL("%s/post".formatted(bytebucketUrl));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "william278/toilet-java-client/%s".formatted(proj));
        connection.setRequestProperty("Content-Encoding", "gzip");
        connection.setDoOutput(true);
        return connection;
    }

    private byte[] compressContent(@NotNull String content) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(content.getBytes(StandardCharsets.UTF_8));
                gzipOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    private void sendRequestData(@NotNull HttpURLConnection connection, byte[] compressedContent) throws IOException {
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(compressedContent);
        }
    }

    private void checkResponseCode(int responseCode) throws IOException {
        if (responseCode >= 400 && responseCode < 600) {
            throw new IOException("Server returned error code: %s".formatted(responseCode));
        }
    }

    @NotNull
    private String getLocationHeader(@NotNull HttpURLConnection connection) throws IOException {
        String locationHeader = connection.getHeaderField("Location");
        if (locationHeader == null) {
            throw new IOException("Location header is missing from the response");
        }
        return locationHeader;
    }
}

