/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.tab;

import com.google.common.collect.Sets;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.PlayerTabList;

public class TabListListener {
    private final Velocitab plugin;
    private final PlayerTabList tabList;
    private final Set<UUID> justQuit;

    public TabListListener(@NotNull Velocitab plugin, @NotNull PlayerTabList tabList) {
        this.plugin = plugin;
        this.tabList = tabList;
        this.justQuit = Sets.newConcurrentHashSet();
    }

    @Subscribe
    private void onKick(@NotNull KickedFromServerEvent event) {
        this.plugin.getTabList().getTaskManager().run(() -> this.handleKick(event));
    }

    private void handleKick(@NotNull KickedFromServerEvent event) {
        event.getPlayer().getTabList().getEntries().stream().filter(entry -> entry.getProfile() != null && !entry.getProfile().getId().equals(event.getPlayer().getUniqueId())).forEach(entry -> event.getPlayer().getTabList().removeEntry(entry.getProfile().getId()));
        event.getPlayer().getTabList().clearHeaderAndFooter();
        if (event.getResult() instanceof KickedFromServerEvent.DisconnectPlayer) {
            this.tabList.removePlayer(event.getPlayer());
        } else {
            KickedFromServerEvent.ServerKickResult serverKickResult = event.getResult();
            if (serverKickResult instanceof KickedFromServerEvent.RedirectPlayer) {
                KickedFromServerEvent.RedirectPlayer redirectPlayer = (KickedFromServerEvent.RedirectPlayer)serverKickResult;
                this.tabList.removePlayer(event.getPlayer());
            } else {
                serverKickResult = event.getResult();
                if (serverKickResult instanceof KickedFromServerEvent.Notify) {
                    KickedFromServerEvent.Notify notify = (KickedFromServerEvent.Notify)serverKickResult;
                    return;
                }
            }
        }
        event.getPlayer().getTabList().removeEntry(event.getPlayer().getUniqueId());
        event.getPlayer().getTabList().clearHeaderAndFooter();
        this.justQuit.add(event.getPlayer().getUniqueId());
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.justQuit.remove(event.getPlayer().getUniqueId())).delay(300L, TimeUnit.MILLISECONDS).schedule();
    }

    @Subscribe(priority=-32768)
    private void onPlayerJoin(@NotNull ServerPostConnectEvent event) {
        this.plugin.getTabList().getTaskManager().run(() -> this.handlePlayerJoin(event));
    }

    private void handlePlayerJoin(@NotNull ServerPostConnectEvent event) {
        Player joined = event.getPlayer();
        String serverName = joined.getCurrentServer().map(ServerConnection::getServerInfo).map(ServerInfo::getName).orElse("");
        Optional<TabPlayer> previousTabPlayer = this.tabList.getTabPlayer(joined);
        Optional<Group> previousGroup = previousTabPlayer.map(TabPlayer::getGroup);
        @NotNull Optional<Group> groupOptional = this.tabList.getGroup(serverName);
        boolean isDefault = groupOptional.map(g -> g.isDefault(this.plugin)).orElse(true);
        this.plugin.getTabList().clearCachedData(joined);
        this.plugin.getPlaceholderManager().clearPlaceholders(joined.getUniqueId());
        previousTabPlayer.ifPresent(player -> player.setLoaded(false));
        if (!this.plugin.getSettings().isShowAllPlayersFromAllGroups() && previousGroup.isPresent() && (groupOptional.isPresent() && !previousGroup.get().equals(groupOptional.get()) || groupOptional.isEmpty())) {
            this.tabList.getPlayers().remove(joined.getUniqueId());
            this.removeOldEntry(previousGroup.get(), joined.getUniqueId());
            if (groupOptional.isEmpty() && joined.getCurrentServer().isPresent()) {
                this.plugin.getTabList().getTaskManager().runDelayed(() -> {
                    RegisteredServer server = ((ServerConnection)joined.getCurrentServer().get()).getServer();
                    Set players = server.getPlayersConnected().stream().map(Player::getUniqueId).collect(Collectors.toSet());
                    HashSet tabPlayers = Sets.newHashSet(this.tabList.getPlayers().keySet());
                    tabPlayers.removeAll(players);
                    tabPlayers.forEach(u -> joined.getTabList().removeEntry(u));
                }, 250L, TimeUnit.MILLISECONDS);
            }
        }
        if (isDefault && !this.plugin.getSettings().isFallbackEnabled() && !groupOptional.map(g -> g.containsServer(this.plugin, serverName)).orElse(false).booleanValue()) {
            if (previousTabPlayer.isEmpty()) {
                return;
            }
            if (event.getPreviousServer() == null) {
                return;
            }
            this.cleanOldHeadersAndFooters(previousTabPlayer.get());
            this.tabList.getPlayers().remove(event.getPlayer().getUniqueId());
            return;
        }
        if (groupOptional.isEmpty()) {
            return;
        }
        Group group = groupOptional.get();
        this.plugin.getScoreboardManager().resetCache(joined, group);
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.plugin.getPlaceholderManager().unblockPlayer(joined.getUniqueId())).delay(10L, TimeUnit.MILLISECONDS).schedule();
        this.tabList.loadPlayer(joined, group, this.justQuit.contains(joined.getUniqueId()) ? 400 : 500);
    }

    @Subscribe(order=PostOrder.CUSTOM, priority=-32768)
    private void onPlayerQuit(@NotNull DisconnectEvent event) {
        this.plugin.getTabList().getTaskManager().run(() -> this.handlePlayerQuit(event));
    }

    private void handlePlayerQuit(@NotNull DisconnectEvent event) {
        if (event.getLoginStatus() == DisconnectEvent.LoginStatus.CONFLICTING_LOGIN) {
            return;
        }
        this.tabList.removePlayer(event.getPlayer());
        this.plugin.getPlaceholderManager().clearPlaceholders(event.getPlayer().getUniqueId());
        this.plugin.getPlaceholderManager().unblockPlayer(event.getPlayer().getUniqueId());
    }

    @Subscribe
    private void proxyReload(@NotNull ProxyReloadEvent event) {
        this.plugin.loadConfigs();
        this.tabList.reloadUpdate();
        this.plugin.log("Velocitab has been reloaded!");
    }

    private void removeOldEntry(@NotNull Group group, @NotNull UUID uuid) {
        this.tabList.getTaskManager().runDelayed(() -> this.tabList.removeOldEntry(group, uuid), 100L, TimeUnit.MILLISECONDS);
    }

    private void cleanOldHeadersAndFooters(@NotNull TabPlayer tabPlayer) {
        Component header = tabPlayer.getLastHeader();
        Component footer = tabPlayer.getLastFooter();
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> {
            Component currentHeader = tabPlayer.getPlayer().getPlayerListHeader();
            Component currentFooter = tabPlayer.getPlayer().getPlayerListFooter();
            if (header.equals(currentHeader) && footer.equals(currentFooter) || currentHeader.equals(Component.empty()) && currentFooter.equals(Component.empty())) {
                tabPlayer.getPlayer().sendPlayerListHeaderAndFooter((Component)Component.empty(), (Component)Component.empty());
                tabPlayer.getPlayer().getCurrentServer().ifPresent(serverConnection -> serverConnection.getServer().getPlayersConnected().forEach(player -> player.getTabList().getEntry(tabPlayer.getPlayer().getUniqueId()).ifPresent(entry -> entry.setDisplayName((Component)Component.text((String)tabPlayer.getPlayer().getUsername())))));
            }
        }).delay(500L, TimeUnit.MILLISECONDS).schedule();
    }
}

