/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.util.DebugSystem;

public class MiniMessageUtil {
    private static final MiniMessageUtil INSTANCE = new MiniMessageUtil();
    private final Pattern legacyRGBPattern = Pattern.compile("#&[0-9a-fA-F]{6}");
    private final Pattern legacyPattern = Pattern.compile("&[0-9a-fA-F]");
    private final Pattern legacySectionPattern = Pattern.compile("\u00a7[0-9a-fA-F]");
    private int errorsCount = 0;

    private MiniMessageUtil() {
    }

    @NotNull
    public String checkForErrors(@NotNull String text) {
        ArrayList errors = Lists.newArrayList();
        String copy = text;
        copy = this.processLegacySections(errors, copy, this.legacyRGBPattern);
        copy = this.processLegacySections(errors, copy, this.legacyPattern);
        copy = this.processLegacySections(errors, copy, this.legacySectionPattern);
        if (this.errorsCount > 0 && this.errorsCount % 10 == 0) {
            ++this.errorsCount;
            DebugSystem.log(DebugSystem.DebugLevel.WARNING, "Found legacy formatting which is not supported if the formatter is set to MINIMESSAGE. Remove the following characters from your config or make sure placeholders don't contain them: " + String.valueOf(errors) + ". & and \u00a7 are replaced with * to prevent issues with MINIMESSAGE.");
            if (this.errorsCount > 100000) {
                this.errorsCount = 0;
            }
        }
        return copy;
    }

    @NotNull
    private String processLegacySections(@NotNull List<String> errors, @NotNull String copy, @NotNull Pattern legacySectionPattern) {
        StringBuilder result = new StringBuilder();
        Matcher legacySectionMatcher = legacySectionPattern.matcher(copy);
        while (legacySectionMatcher.find()) {
            errors.add(legacySectionMatcher.group());
            String matched = legacySectionMatcher.group();
            String replaced = "*" + matched.substring(1);
            legacySectionMatcher.appendReplacement(result, Matcher.quoteReplacement(replaced));
            ++this.errorsCount;
        }
        legacySectionMatcher.appendTail(result);
        return result.toString();
    }

    @Generated
    public static MiniMessageUtil getINSTANCE() {
        return INSTANCE;
    }
}

