/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.api;

import com.google.common.collect.Maps;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelMessageSource;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.UpdateTeamsPacket;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.util.DebugSystem;

public class PluginMessageAPI {
    private static final Map<MinecraftChannelIdentifier, PluginMessageRequest> CHANNELS = Maps.newHashMap();
    private final Velocitab plugin;
    private final Map<String, MinecraftChannelIdentifier> channels;

    public PluginMessageAPI(@NotNull Velocitab plugin) {
        this.plugin = plugin;
        this.channels = Maps.newHashMap();
    }

    public void registerChannel() {
        Arrays.stream(PluginMessageRequest.values()).forEach(request -> {
            String requestName = request.name().toLowerCase(Locale.ENGLISH);
            String channelName = "velocitab:" + requestName;
            MinecraftChannelIdentifier channel = MinecraftChannelIdentifier.from((String)channelName);
            this.channels.put(channelName, channel);
            this.plugin.getServer().getChannelRegistrar().register(new ChannelIdentifier[]{channel});
            CHANNELS.put(channel, (PluginMessageRequest)((Object)request));
        });
        this.plugin.getServer().getEventManager().register((Object)this.plugin, PluginMessageEvent.class, this::onPluginMessage);
    }

    public void unregisterChannel() {
        this.channels.forEach((name, channel) -> this.plugin.getServer().getChannelRegistrar().unregister(new ChannelIdentifier[]{channel}));
    }

    private void onPluginMessage(@NotNull PluginMessageEvent pluginMessageEvent) {
        Optional<MinecraftChannelIdentifier> channel = Optional.ofNullable(this.channels.get(pluginMessageEvent.getIdentifier().getId()));
        if (channel.isEmpty()) {
            return;
        }
        ChannelMessageSource channelMessageSource = pluginMessageEvent.getSource();
        if (!(channelMessageSource instanceof ServerConnection)) {
            return;
        }
        ServerConnection serverConnection = (ServerConnection)channelMessageSource;
        Player player = serverConnection.getPlayer();
        Optional<TabPlayer> optionalTabPlayer = this.plugin.getTabList().getTabPlayer(player);
        if (optionalTabPlayer.isEmpty()) {
            return;
        }
        TabPlayer tabPlayer = optionalTabPlayer.get();
        if (!tabPlayer.isLoaded()) {
            return;
        }
        Optional<PluginMessageRequest> request = PluginMessageRequest.get(channel.get());
        if (request.isEmpty()) {
            return;
        }
        String data = new String(pluginMessageEvent.getData());
        this.handleAPIRequest(tabPlayer, request.get(), data);
    }

    private void handleAPIRequest(@NotNull TabPlayer tabPlayer, @NotNull PluginMessageRequest request, @NotNull String arg) {
        switch (request.ordinal()) {
            case 0: {
                tabPlayer.setCustomName(arg);
                this.plugin.getTabList().updatePlayer(tabPlayer, true);
                break;
            }
            case 1: {
                String clean = arg.replaceAll("&", "").replaceAll("\u00a7", "");
                if (clean.isEmpty()) {
                    return;
                }
                char colorChar = clean.charAt(0);
                UpdateTeamsPacket.TeamColor color = UpdateTeamsPacket.TeamColor.getColor(colorChar);
                DebugSystem.log(DebugSystem.DebugLevel.DEBUG, "Team color for " + tabPlayer.getPlayer().getUsername() + " is " + String.valueOf((Object)color) + " (" + arg + ")");
                tabPlayer.setTeamColor(color);
                this.plugin.getTabList().updatePlayer(tabPlayer, true);
            }
        }
    }

    private static enum PluginMessageRequest {
        UPDATE_CUSTOM_NAME,
        UPDATE_TEAM_COLOR;


        public static Optional<PluginMessageRequest> get(@NotNull MinecraftChannelIdentifier channelIdentifier) {
            return Optional.ofNullable(CHANNELS.get(channelIdentifier));
        }
    }
}

