/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import io.netty.util.collection.IntObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.william278.velocitab.libraries.annotations.NotNull;

public final class PacketRegistration<P extends MinecraftPacket> {
    private final Class<P> packetClass;
    private Supplier<P> packetSupplier;
    private ProtocolUtils.Direction direction;
    private StateRegistry stateRegistry;
    private final List<StateRegistry.PacketMapping> mappings = new ArrayList<StateRegistry.PacketMapping>();
    private static final MethodHandle STATE_REGISTRY$clientBound;
    private static final MethodHandle STATE_REGISTRY$serverBound;
    private static final MethodHandle PACKET_REGISTRY$register;
    private static final MethodHandle PACKET_REGISTRY$packetIdToSupplier;
    private static final MethodHandle PACKET_REGISTRY$packetClassToId;
    private static final MethodHandle PACKET_REGISTRY$versions;
    private static final MethodHandle PACKET_MAPPING$map;

    public PacketRegistration<P> packetSupplier(@NotNull Supplier<P> packetSupplier) {
        this.packetSupplier = packetSupplier;
        return this;
    }

    public PacketRegistration<P> direction(ProtocolUtils.Direction direction) {
        this.direction = direction;
        return this;
    }

    public PacketRegistration<P> stateRegistry(@NotNull StateRegistry stateRegistry) {
        this.stateRegistry = stateRegistry;
        return this;
    }

    public PacketRegistration<P> mapping(int id, ProtocolVersion version, boolean encodeOnly) {
        try {
            StateRegistry.PacketMapping mapping = PACKET_MAPPING$map.invoke(id, version, encodeOnly);
            this.mappings.add(mapping);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return this;
    }

    public void register() {
        try {
            StateRegistry.PacketRegistry packetRegistry = this.direction == ProtocolUtils.Direction.CLIENTBOUND ? STATE_REGISTRY$clientBound.invoke(this.stateRegistry) : STATE_REGISTRY$serverBound.invoke(this.stateRegistry);
            PACKET_REGISTRY$register.invoke(packetRegistry, this.packetClass, this.packetSupplier, (StateRegistry.PacketMapping[])this.mappings.toArray(StateRegistry.PacketMapping[]::new));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void unregister() {
        try {
            StateRegistry.PacketRegistry packetRegistry = this.direction == ProtocolUtils.Direction.CLIENTBOUND ? STATE_REGISTRY$clientBound.invoke(this.stateRegistry) : STATE_REGISTRY$serverBound.invoke(this.stateRegistry);
            Map versions = PACKET_REGISTRY$versions.invoke(packetRegistry);
            versions.forEach((protocolVersion, protocolRegistry) -> {
                try {
                    IntObjectMap packetIdToSupplier = PACKET_REGISTRY$packetIdToSupplier.invoke((StateRegistry.PacketRegistry.ProtocolRegistry)protocolRegistry);
                    Object2IntMap packetClassToId = PACKET_REGISTRY$packetClassToId.invoke((StateRegistry.PacketRegistry.ProtocolRegistry)protocolRegistry);
                    Set.copyOf(packetIdToSupplier.keySet()).stream().filter(supplier -> ((Supplier)packetIdToSupplier.get(supplier)).get().getClass().equals(this.packetClass)).forEach(arg_0 -> packetIdToSupplier.remove(arg_0));
                    packetClassToId.values().intStream().filter(id -> Objects.equals(packetClassToId.getInt(this.packetClass), id)).forEach(arg_0 -> ((Object2IntMap)packetClassToId).removeInt(arg_0));
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            });
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <P extends MinecraftPacket> PacketRegistration<P> of(Class<P> packetClass) {
        return new PacketRegistration<P>(packetClass);
    }

    private PacketRegistration(@NotNull Class<P> packetClass) {
        this.packetClass = packetClass;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            MethodHandles.Lookup stateRegistryLookup = MethodHandles.privateLookupIn(StateRegistry.class, lookup);
            STATE_REGISTRY$clientBound = stateRegistryLookup.findGetter(StateRegistry.class, "clientbound", StateRegistry.PacketRegistry.class);
            STATE_REGISTRY$serverBound = stateRegistryLookup.findGetter(StateRegistry.class, "serverbound", StateRegistry.PacketRegistry.class);
            MethodType mapType = MethodType.methodType(StateRegistry.PacketMapping.class, Integer.TYPE, ProtocolVersion.class, Boolean.TYPE);
            PACKET_MAPPING$map = stateRegistryLookup.findStatic(StateRegistry.class, "map", mapType);
            MethodHandles.Lookup packetRegistryLookup = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.class, lookup);
            MethodType registerType = MethodType.methodType(Void.TYPE, Class.class, Supplier.class, StateRegistry.PacketMapping[].class);
            PACKET_REGISTRY$register = packetRegistryLookup.findVirtual(StateRegistry.PacketRegistry.class, "register", registerType);
            PACKET_REGISTRY$versions = packetRegistryLookup.findGetter(StateRegistry.PacketRegistry.class, "versions", Map.class);
            MethodHandles.Lookup protocolRegistryLookup = MethodHandles.privateLookupIn(StateRegistry.PacketRegistry.ProtocolRegistry.class, lookup);
            PACKET_REGISTRY$packetIdToSupplier = protocolRegistryLookup.findGetter(StateRegistry.PacketRegistry.ProtocolRegistry.class, "packetIdToSupplier", IntObjectMap.class);
            PACKET_REGISTRY$packetClassToId = protocolRegistryLookup.findGetter(StateRegistry.PacketRegistry.ProtocolRegistry.class, "packetClassToId", Object2IntMap.class);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

