/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.mvel2.ast;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.william278.velocitab.libraries.mvel2.CompileException;
import net.william278.velocitab.libraries.mvel2.DataConversion;
import net.william278.velocitab.libraries.mvel2.ParserContext;
import net.william278.velocitab.libraries.mvel2.UnresolveablePropertyException;
import net.william278.velocitab.libraries.mvel2.ast.ASTNode;
import net.william278.velocitab.libraries.mvel2.ast.Function;
import net.william278.velocitab.libraries.mvel2.ast.InvokationContextFactory;
import net.william278.velocitab.libraries.mvel2.compiler.ExecutableStatement;
import net.william278.velocitab.libraries.mvel2.integration.VariableResolver;
import net.william278.velocitab.libraries.mvel2.integration.VariableResolverFactory;
import net.william278.velocitab.libraries.mvel2.integration.impl.MapVariableResolverFactory;
import net.william278.velocitab.libraries.mvel2.integration.impl.SimpleValueResolver;
import net.william278.velocitab.libraries.mvel2.util.CallableProxy;
import net.william278.velocitab.libraries.mvel2.util.SimpleIndexHashMapWrapper;

public class Proto
extends ASTNode {
    private String name;
    private Map<String, Receiver> receivers;
    private int cursorStart;
    private int cursorEnd;

    public Proto(String name, ParserContext pCtx) {
        super(pCtx);
        this.name = name;
        this.receivers = new SimpleIndexHashMapWrapper<String, Receiver>();
    }

    public Receiver declareReceiver(String name, Function function) {
        Receiver r = new Receiver(null, ReceiverType.FUNCTION, function);
        this.receivers.put(name, r);
        return r;
    }

    public Receiver declareReceiver(String name, Class type, ExecutableStatement initCode) {
        Receiver r = new Receiver(null, ReceiverType.PROPERTY, initCode);
        this.receivers.put(name, r);
        return r;
    }

    public Receiver declareReceiver(String name, ReceiverType type, ExecutableStatement initCode) {
        Receiver r = new Receiver(null, type, initCode);
        this.receivers.put(name, r);
        return r;
    }

    public ProtoInstance newInstance(Object ctx, Object thisCtx, VariableResolverFactory factory) {
        return new ProtoInstance(this, ctx, thisCtx, factory);
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory.createVariable(this.name, this);
        return this;
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory.createVariable(this.name, this);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "proto " + this.name;
    }

    public void setCursorPosition(int start, int end) {
        this.cursorStart = start;
        this.cursorEnd = end;
    }

    public int getCursorStart() {
        return this.cursorStart;
    }

    public int getCursorEnd() {
        return this.cursorEnd;
    }

    public class ProtoResolver
    implements VariableResolver {
        private String name;
        private Class<?> knownType;
        private Map<String, Object> variableMap;

        public ProtoResolver(Map<String, Object> variableMap, String name) {
            this.variableMap = variableMap;
            this.name = name;
        }

        public ProtoResolver(Map<String, Object> variableMap, String name, Class knownType) {
            this.name = name;
            this.knownType = knownType;
            this.variableMap = variableMap;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void setStaticType(Class knownType) {
            this.knownType = knownType;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Class getType() {
            return this.knownType;
        }

        @Override
        public void setValue(Object value) {
            if (this.knownType != null && value != null && value.getClass() != this.knownType) {
                if (!DataConversion.canConvert(this.knownType, value.getClass())) {
                    throw new CompileException("cannot assign " + value.getClass().getName() + " to type: " + this.knownType.getName(), Proto.this.expr, Proto.this.start);
                }
                try {
                    value = DataConversion.convert(value, this.knownType);
                }
                catch (Exception e) {
                    throw new CompileException("cannot convert value of " + value.getClass().getName() + " to: " + this.knownType.getName(), Proto.this.expr, Proto.this.start);
                }
            }
            ((Receiver)this.variableMap.get(this.name)).receiver = value;
        }

        @Override
        public Object getValue() {
            return ((Receiver)this.variableMap.get(this.name)).receiver;
        }

        @Override
        public int getFlags() {
            return 0;
        }
    }

    public class ProtoContextFactory
    extends MapVariableResolverFactory {
        private final SimpleIndexHashMapWrapper<String, VariableResolver> variableResolvers;

        public ProtoContextFactory(SimpleIndexHashMapWrapper variables) {
            super(variables);
            this.variableResolvers = new SimpleIndexHashMapWrapper(variables, true);
        }

        @Override
        public VariableResolver createVariable(String name, Object value) {
            try {
                VariableResolver vr = this.getVariableResolver(name);
                vr.setValue(value);
                return vr;
            }
            catch (UnresolveablePropertyException e) {
                ProtoResolver vr = new ProtoResolver(this.variables, name);
                this.addResolver(name, vr).setValue(value);
                return vr;
            }
        }

        @Override
        public VariableResolver createVariable(String name, Object value, Class<?> type) {
            VariableResolver vr;
            try {
                vr = this.getVariableResolver(name);
            }
            catch (UnresolveablePropertyException e) {
                vr = null;
            }
            if (vr != null && vr.getType() != null) {
                throw new CompileException("variable already defined within scope: " + vr.getType() + " " + name, Proto.this.expr, Proto.this.start);
            }
            vr = new ProtoResolver(this.variables, name, type);
            this.addResolver(name, vr).setValue(value);
            return vr;
        }

        @Override
        public void setIndexedVariableNames(String[] indexedVariableNames) {
        }

        @Override
        public String[] getIndexedVariableNames() {
            return null;
        }

        @Override
        public VariableResolver createIndexedVariable(int index, String name, Object value, Class<?> type) {
            VariableResolver vr;
            VariableResolver variableResolver = vr = this.variableResolvers != null ? this.variableResolvers.getByIndex(index) : null;
            if (vr != null && vr.getType() != null) {
                throw new CompileException("variable already defined within scope: " + vr.getType() + " " + name, Proto.this.expr, Proto.this.start);
            }
            return this.createIndexedVariable(this.variableIndexOf(name), name, value);
        }

        @Override
        public VariableResolver createIndexedVariable(int index, String name, Object value) {
            VariableResolver vr = this.variableResolvers.getByIndex(index);
            if (vr == null) {
                vr = new SimpleValueResolver(value);
                this.variableResolvers.putAtIndex(index, vr);
            } else {
                vr.setValue(value);
            }
            return this.indexedVariableResolvers[index];
        }

        @Override
        public VariableResolver getIndexedVariableResolver(int index) {
            return this.variableResolvers.getByIndex(index);
        }

        @Override
        public VariableResolver setIndexedVariableResolver(int index, VariableResolver resolver) {
            this.variableResolvers.putAtIndex(index, resolver);
            return resolver;
        }

        @Override
        public int variableIndexOf(String name) {
            return this.variableResolvers.indexOf(name);
        }

        @Override
        public VariableResolver getVariableResolver(String name) {
            VariableResolver vr = this.variableResolvers.get(name);
            if (vr != null) {
                return vr;
            }
            if (this.variables.containsKey(name)) {
                vr = new ProtoResolver(this.variables, name);
                this.variableResolvers.put(name, vr);
                return vr;
            }
            if (this.nextFactory != null) {
                return this.nextFactory.getVariableResolver(name);
            }
            throw new UnresolveablePropertyException("unable to resolve variable '" + name + "'");
        }
    }

    public class ProtoInstance
    implements Map<String, Receiver> {
        private Proto protoType;
        private VariableResolverFactory instanceStates;
        private SimpleIndexHashMapWrapper<String, Receiver> receivers;

        public ProtoInstance(Proto protoType, Object ctx, Object thisCtx, VariableResolverFactory factory) {
            this.protoType = protoType;
            this.receivers = new SimpleIndexHashMapWrapper();
            for (Map.Entry entry : protoType.receivers.entrySet()) {
                this.receivers.put((String)entry.getKey(), ((Receiver)entry.getValue()).init(this, ctx, thisCtx, factory));
            }
            this.instanceStates = new ProtoContextFactory(this.receivers);
        }

        public Proto getProtoType() {
            return this.protoType;
        }

        @Override
        public int size() {
            return this.receivers.size();
        }

        @Override
        public boolean isEmpty() {
            return this.receivers.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.receivers.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.receivers.containsValue(value);
        }

        @Override
        public Receiver get(Object key) {
            return this.receivers.get(key);
        }

        @Override
        public Receiver put(String key, Receiver value) {
            return this.receivers.put(key, value);
        }

        @Override
        public Receiver remove(Object key) {
            return this.receivers.remove(key);
        }

        @Override
        public void putAll(Map m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return this.receivers.keySet();
        }

        @Override
        public Collection<Receiver> values() {
            return this.receivers.values();
        }

        @Override
        public Set<Map.Entry<String, Receiver>> entrySet() {
            return this.receivers.entrySet();
        }
    }

    public static enum ReceiverType {
        DEFERRED,
        FUNCTION,
        PROPERTY;

    }

    public class Receiver
    implements CallableProxy {
        private ReceiverType type;
        private Object receiver;
        private ExecutableStatement initValue;
        private ProtoInstance instance;

        public Receiver(ProtoInstance protoInstance, ReceiverType type, Object receiver) {
            this.instance = protoInstance;
            this.type = type;
            this.receiver = receiver;
        }

        public Receiver(ProtoInstance protoInstance, ReceiverType type, ExecutableStatement stmt) {
            this.instance = protoInstance;
            this.type = type;
            this.initValue = stmt;
        }

        @Override
        public Object call(Object ctx, Object thisCtx, VariableResolverFactory factory, Object[] parms) {
            switch (this.type) {
                case FUNCTION: {
                    return ((Function)this.receiver).call(ctx, thisCtx, new InvokationContextFactory(factory, this.instance.instanceStates), parms);
                }
                case PROPERTY: {
                    return this.receiver;
                }
                case DEFERRED: {
                    throw new CompileException("unresolved prototype receiver", Proto.this.expr, Proto.this.start);
                }
            }
            return null;
        }

        public Receiver init(ProtoInstance instance, Object ctx, Object thisCtx, VariableResolverFactory factory) {
            return new Receiver(instance, this.type, this.type == ReceiverType.PROPERTY && this.initValue != null ? this.initValue.getValue(ctx, thisCtx, factory) : this.receiver);
        }

        public void setType(ReceiverType type) {
            this.type = type;
        }

        public void setInitValue(ExecutableStatement initValue) {
            this.initValue = initValue;
        }
    }
}

