/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Set;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.Protocol765Adapter;
import net.william278.velocitab.packet.UpdateTeamsPacket;

public class Protocol770Adapter
extends Protocol765Adapter {
    public Protocol770Adapter(@NotNull Velocitab plugin) {
        super(plugin, Set.of(ProtocolVersion.MINECRAFT_1_21_5, ProtocolVersion.MINECRAFT_1_21_6, ProtocolVersion.MINECRAFT_1_21_7, ProtocolVersion.MINECRAFT_1_21_9));
    }

    @Override
    public void decode(@NotNull ByteBuf byteBuf, @NotNull UpdateTeamsPacket packet, @NotNull ProtocolVersion protocolVersion) {
        packet.teamName(ProtocolUtils.readString((ByteBuf)byteBuf));
        UpdateTeamsPacket.UpdateMode mode = UpdateTeamsPacket.UpdateMode.byId(byteBuf.readByte());
        packet.mode(mode);
        if (mode == UpdateTeamsPacket.UpdateMode.REMOVE_TEAM) {
            return;
        }
        if (mode == UpdateTeamsPacket.UpdateMode.CREATE_TEAM || mode == UpdateTeamsPacket.UpdateMode.UPDATE_INFO) {
            packet.displayName(this.readComponent(byteBuf));
            packet.friendlyFlags(UpdateTeamsPacket.FriendlyFlag.fromBitMask(byteBuf.readByte()));
            packet.nametagVisibility(UpdateTeamsPacket.NametagVisibility.byOrdinal(ProtocolUtils.readVarInt((ByteBuf)byteBuf)));
            packet.collisionRule(UpdateTeamsPacket.CollisionRule.byOrdinal(ProtocolUtils.readVarInt((ByteBuf)byteBuf)));
            packet.color(byteBuf.readByte());
            packet.prefix(this.readComponent(byteBuf));
            packet.suffix(this.readComponent(byteBuf));
        }
        if (mode == UpdateTeamsPacket.UpdateMode.CREATE_TEAM || mode == UpdateTeamsPacket.UpdateMode.ADD_PLAYERS || mode == UpdateTeamsPacket.UpdateMode.REMOVE_PLAYERS) {
            int count = ProtocolUtils.readVarInt((ByteBuf)byteBuf);
            ArrayList<String> entities = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                entities.add(ProtocolUtils.readString((ByteBuf)byteBuf));
            }
            packet.entities(entities);
        }
    }

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull UpdateTeamsPacket packet, @NotNull ProtocolVersion protocolVersion) {
        ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)packet.teamName());
        UpdateTeamsPacket.UpdateMode mode = packet.mode();
        byteBuf.writeByte((int)mode.id());
        if (mode == UpdateTeamsPacket.UpdateMode.REMOVE_TEAM) {
            return;
        }
        if (mode == UpdateTeamsPacket.UpdateMode.CREATE_TEAM || mode == UpdateTeamsPacket.UpdateMode.UPDATE_INFO) {
            this.writeComponent(byteBuf, packet.displayName());
            byteBuf.writeByte(UpdateTeamsPacket.FriendlyFlag.toBitMask(packet.friendlyFlags()));
            ProtocolUtils.writeVarInt((ByteBuf)byteBuf, (int)packet.nametagVisibility().ordinal());
            ProtocolUtils.writeVarInt((ByteBuf)byteBuf, (int)packet.collisionRule().ordinal());
            byteBuf.writeByte(packet.color());
            this.writeComponent(byteBuf, packet.prefix());
            this.writeComponent(byteBuf, packet.suffix());
        }
        if (mode == UpdateTeamsPacket.UpdateMode.CREATE_TEAM || mode == UpdateTeamsPacket.UpdateMode.ADD_PLAYERS || mode == UpdateTeamsPacket.UpdateMode.REMOVE_PLAYERS) {
            ArrayList entities = packet.entities();
            ProtocolUtils.writeVarInt((ByteBuf)byteBuf, (int)(entities != null ? entities.size() : 0));
            for (String entity : entities != null ? entities : new ArrayList()) {
                ProtocolUtils.writeString((ByteBuf)byteBuf, (CharSequence)entity);
            }
        }
    }
}

