/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.PacketRegistration;
import net.william278.velocitab.packet.Protocol404Adapter;
import net.william278.velocitab.packet.Protocol48Adapter;
import net.william278.velocitab.packet.Protocol735Adapter;
import net.william278.velocitab.packet.Protocol765Adapter;
import net.william278.velocitab.packet.Protocol770Adapter;
import net.william278.velocitab.packet.TeamsPacketAdapter;
import net.william278.velocitab.packet.UpdateTeamsPacket;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.sorting.SortedSet;
import net.william278.velocitab.tab.Nametag;
import net.william278.velocitab.util.DebugSystem;
import org.slf4j.event.Level;

public class ScoreboardManager {
    private PacketRegistration<UpdateTeamsPacket> packetRegistration;
    private final Velocitab plugin;
    private final boolean teams;
    private final Map<ProtocolVersion, TeamsPacketAdapter> versions;
    private final Map<UUID, String> createdTeams;
    private final Map<String, Nametag> nametags;
    private final Multimap<UUID, String> trackedTeams;
    private final SortedSet sortedTeams;

    public ScoreboardManager(@NotNull Velocitab velocitab, boolean teams) {
        this.plugin = velocitab;
        this.teams = teams;
        this.createdTeams = Maps.newConcurrentMap();
        this.nametags = Maps.newConcurrentMap();
        this.versions = Maps.newHashMap();
        this.trackedTeams = Multimaps.synchronizedMultimap((Multimap)Multimaps.newSetMultimap((Map)Maps.newConcurrentMap(), Sets::newConcurrentHashSet));
        this.sortedTeams = new SortedSet(Comparator.reverseOrder());
        this.registerVersions();
    }

    public boolean handleTeams() {
        return this.teams;
    }

    private void registerVersions() {
        try {
            Protocol770Adapter protocol770Adapter = new Protocol770Adapter(this.plugin);
            protocol770Adapter.getProtocolVersions().forEach(version -> this.versions.put((ProtocolVersion)version, protocol770Adapter));
            Protocol765Adapter protocol765Adapter = new Protocol765Adapter(this.plugin);
            protocol765Adapter.getProtocolVersions().forEach(version -> this.versions.put((ProtocolVersion)version, protocol765Adapter));
            Protocol735Adapter protocol735Adapter = new Protocol735Adapter(this.plugin);
            protocol735Adapter.getProtocolVersions().forEach(version -> this.versions.put((ProtocolVersion)version, protocol735Adapter));
            Protocol404Adapter protocol404Adapter = new Protocol404Adapter(this.plugin);
            protocol404Adapter.getProtocolVersions().forEach(version -> this.versions.put((ProtocolVersion)version, protocol404Adapter));
            Protocol48Adapter protocol48Adapter = new Protocol48Adapter(this.plugin);
            protocol48Adapter.getProtocolVersions().forEach(version -> this.versions.put((ProtocolVersion)version, protocol48Adapter));
        }
        catch (NoSuchFieldError e) {
            throw new IllegalStateException("Failed to register Scoreboard Teams packets. Velocitab probably does not (yet) support your Proxy version.", e);
        }
    }

    public boolean isInternalTeam(@NotNull String teamName) {
        return this.nametags.containsKey(teamName);
    }

    public int getPosition(@NotNull String teamName) {
        return this.sortedTeams.getPosition(teamName);
    }

    @NotNull
    public TeamsPacketAdapter getPacketAdapter(@NotNull ProtocolVersion version) {
        return Optional.ofNullable(this.versions.get(version)).orElseThrow(() -> new IllegalArgumentException("No adapter found for protocol version " + String.valueOf(version) + ". Are you sure you're using the latest version of Velocitab and latest build of Velocity?"));
    }

    public void close() {
        this.plugin.getServer().getAllPlayers().forEach(this::resetCache);
    }

    public void resetCache(@NotNull Player player) {
        String team = this.createdTeams.remove(player.getUniqueId());
        if (team != null) {
            this.removeSortedTeam(team);
            this.plugin.getTabList().getTabPlayer(player).ifPresent(tabPlayer -> this.dispatchGroupPacket(UpdateTeamsPacket.removeTeam(this.plugin, team), (TabPlayer)tabPlayer));
            this.trackedTeams.removeAll((Object)player.getUniqueId());
        }
    }

    public void resetCache(@NotNull Player player, @NotNull Group group) {
        String team = this.createdTeams.remove(player.getUniqueId());
        if (team != null) {
            this.removeSortedTeam(team);
            this.dispatchGroupPacket(UpdateTeamsPacket.removeTeam(this.plugin, team), group);
        }
    }

    private void removeSortedTeam(@NotNull String teamName) {
        boolean result = this.sortedTeams.removeTeam(teamName);
        if (!result) {
            DebugSystem.log(DebugSystem.DebugLevel.ERROR, "Failed to remove team " + teamName + " from sortedTeams");
        }
    }

    public void vanishPlayer(@NotNull TabPlayer tabPlayer) {
        this.handleVanish(tabPlayer, true);
    }

    public void unVanishPlayer(@NotNull TabPlayer tabPlayer) {
        this.handleVanish(tabPlayer, false);
    }

    private void handleVanish(@NotNull TabPlayer tabPlayer, boolean vanish) {
        if (!this.plugin.getSettings().isSortPlayers()) {
            return;
        }
        Player player = tabPlayer.getPlayer();
        String teamName = this.createdTeams.get(player.getUniqueId());
        if (teamName == null) {
            return;
        }
        List<RegisteredServer> siblings = tabPlayer.getGroup().registeredServers(this.plugin);
        boolean isNameTagEmpty = tabPlayer.getGroup().nametag().isEmpty() && !this.plugin.getSettings().isRemoveNametags();
        Optional<Nametag> cachedTag = Optional.ofNullable(this.nametags.getOrDefault(teamName, null));
        cachedTag.ifPresent(nametag -> siblings.forEach(server -> server.getPlayersConnected().stream().filter(p -> p != player).forEach(connected -> {
            if (vanish && !this.plugin.getVanishManager().canSee(connected.getUsername(), player.getUsername())) {
                this.sendPacket((Player)connected, UpdateTeamsPacket.removeTeam(this.plugin, teamName), isNameTagEmpty);
                this.trackedTeams.remove((Object)connected.getUniqueId(), (Object)teamName);
            } else {
                this.dispatchGroupCreatePacket(this.plugin, tabPlayer, teamName, (Nametag)nametag, player.getUsername());
            }
        })));
    }

    public boolean updateRole(@NotNull TabPlayer tabPlayer, @NotNull String role, boolean force) {
        Player player = tabPlayer.getPlayer();
        if (!player.isActive()) {
            this.plugin.getTabList().removeOfflinePlayer(player);
            DebugSystem.log(DebugSystem.DebugLevel.INFO, "Player " + player.getUsername() + " is not active, removing from tab list");
            return false;
        }
        String name = player.getUsername();
        Nametag nametag = tabPlayer.getNametag(this.plugin);
        if (!this.createdTeams.getOrDefault(player.getUniqueId(), "").equals(role)) {
            String oldRole;
            if (this.createdTeams.containsKey(player.getUniqueId())) {
                this.dispatchGroupPacket(UpdateTeamsPacket.removeTeam(this.plugin, this.createdTeams.get(player.getUniqueId())), tabPlayer);
            }
            if ((oldRole = this.createdTeams.remove(player.getUniqueId())) != null) {
                this.removeSortedTeam(oldRole);
            }
            this.createdTeams.put(player.getUniqueId(), role);
            boolean a = this.sortedTeams.addTeam(role);
            if (!a) {
                DebugSystem.log(DebugSystem.DebugLevel.ERROR, "Failed to add team " + role + " to sortedTeams");
                return false;
            }
            this.nametags.put(role, nametag);
            this.dispatchGroupCreatePacket(this.plugin, tabPlayer, role, nametag, name);
        } else if (force || this.nametags.containsKey(role) && !this.nametags.get(role).equals(nametag)) {
            this.nametags.put(role, nametag);
            this.dispatchGroupChangePacket(this.plugin, tabPlayer, role, nametag, force);
        } else {
            this.updatePlaceholders(tabPlayer);
        }
        return true;
    }

    public void updatePlaceholders(@NotNull TabPlayer tabPlayer) {
        Player player = tabPlayer.getPlayer();
        String role = this.createdTeams.get(player.getUniqueId());
        if (role == null) {
            return;
        }
        Optional<Nametag> optionalNametag = Optional.ofNullable(this.nametags.get(role));
        optionalNametag.ifPresent(nametag -> this.dispatchGroupChangePacket(this.plugin, tabPlayer, role, (Nametag)nametag, false));
    }

    public void resendAllTeams(@NotNull TabPlayer tabPlayer) {
        if (!this.teams) {
            return;
        }
        if (!this.plugin.getSettings().isSendScoreboardPackets()) {
            return;
        }
        Player player = tabPlayer.getPlayer();
        List<Player> players = tabPlayer.getGroup().getPlayers(this.plugin, tabPlayer);
        HashSet roles = Sets.newHashSet();
        players.forEach(p -> {
            if (p == player || !p.isActive()) {
                return;
            }
            if (!this.plugin.getVanishManager().canSee(player.getUsername(), p.getUsername())) {
                return;
            }
            String role = this.createdTeams.getOrDefault(p.getUniqueId(), "");
            if (role.isEmpty()) {
                return;
            }
            Optional<TabPlayer> optionalTabPlayer = this.plugin.getTabList().getTabPlayer((Player)p);
            if (optionalTabPlayer.isEmpty()) {
                return;
            }
            TabPlayer targetTabPlayer = optionalTabPlayer.get();
            if (roles.contains(role)) {
                return;
            }
            roles.add(role);
            Nametag tag = this.nametags.get(role);
            if (tag != null) {
                this.dispatchCreatePacket(this.plugin, targetTabPlayer, role, tag, tabPlayer, p.getUsername());
            }
        });
    }

    private void dispatchGroupCreatePacket(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer, @NotNull String teamName, @NotNull Nametag nametag, String ... teamMembers) {
        if (!this.teams) {
            return;
        }
        tabPlayer.getGroup().getTabPlayers(plugin, tabPlayer).forEach(viewer -> {
            if (!viewer.getPlayer().isActive()) {
                return;
            }
            this.dispatchCreatePacket(plugin, tabPlayer, teamName, nametag, (TabPlayer)viewer, teamMembers);
        });
    }

    private void dispatchCreatePacket(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer, @NotNull String teamName, @NotNull Nametag nametag, @NotNull TabPlayer viewer, String ... teamMembers) {
        if (!this.teams) {
            return;
        }
        boolean canSee = plugin.getVanishManager().canSee(viewer.getPlayer().getUsername(), tabPlayer.getPlayer().getUsername());
        if (!canSee) {
            return;
        }
        UpdateTeamsPacket packet = UpdateTeamsPacket.create(plugin, tabPlayer, teamName, nametag, viewer, teamMembers);
        this.trackedTeams.put((Object)viewer.getPlayer().getUniqueId(), (Object)teamName);
        boolean isNameTagEmpty = tabPlayer.getGroup().nametag().isEmpty() && !plugin.getSettings().isRemoveNametags();
        this.sendPacket(viewer.getPlayer(), packet, isNameTagEmpty);
    }

    private void dispatchGroupChangePacket(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer, @NotNull String teamName, @NotNull Nametag nametag, boolean force) {
        if (!this.teams) {
            return;
        }
        boolean isNameTagEmpty = tabPlayer.getGroup().nametag().isEmpty() && !plugin.getSettings().isRemoveNametags();
        tabPlayer.getGroup().getTabPlayers(plugin, tabPlayer).forEach(viewer -> {
            if (!viewer.getPlayer().isActive()) {
                return;
            }
            boolean canSee = plugin.getVanishManager().canSee(viewer.getPlayer().getUsername(), tabPlayer.getPlayer().getUsername());
            if (!canSee) {
                return;
            }
            if (!this.trackedTeams.containsEntry((Object)viewer.getPlayer().getUniqueId(), (Object)teamName)) {
                return;
            }
            UpdateTeamsPacket packet = UpdateTeamsPacket.changeNametag(plugin, tabPlayer, teamName, viewer, nametag);
            Component prefix = packet.prefix();
            Component suffix = packet.suffix();
            Optional<Component[]> cached = tabPlayer.getRelationalNametag(viewer.getPlayer().getUniqueId());
            if (!force && cached.isPresent() && cached.get()[0].equals((Object)prefix) && cached.get()[1].equals((Object)suffix)) {
                return;
            }
            tabPlayer.setRelationalNametag(viewer.getPlayer().getUniqueId(), prefix, suffix);
            this.sendPacket(viewer.getPlayer(), packet, isNameTagEmpty);
        });
    }

    private void dispatchGroupPacket(@NotNull UpdateTeamsPacket packet, @NotNull Group group) {
        if (!this.teams) {
            return;
        }
        boolean isRemove = packet.isRemoveTeam();
        boolean isNameTagEmpty = group.nametag().isEmpty();
        group.registeredServers(this.plugin).forEach(server -> server.getPlayersConnected().forEach(connected -> {
            try {
                this.sendPacket((Player)connected, packet, isNameTagEmpty);
                if (isRemove) {
                    this.trackedTeams.remove((Object)connected.getUniqueId(), (Object)packet.teamName());
                }
            }
            catch (Throwable e) {
                this.plugin.log(Level.ERROR, "Failed to dispatch packet (unsupported client or server version)", e);
            }
        }));
    }

    private void dispatchGroupPacket(@NotNull UpdateTeamsPacket packet, @NotNull TabPlayer tabPlayer) {
        if (!this.teams) {
            return;
        }
        Player player = tabPlayer.getPlayer();
        Optional optionalServerConnection = player.getCurrentServer();
        if (optionalServerConnection.isEmpty()) {
            return;
        }
        List<Player> players = tabPlayer.getGroup().getPlayers(this.plugin);
        boolean isNameTagEmpty = tabPlayer.getGroup().nametag().isEmpty() && !this.plugin.getSettings().isRemoveNametags();
        players.forEach(connected -> {
            try {
                boolean canSee = this.plugin.getVanishManager().canSee(connected.getUsername(), player.getUsername());
                if (!canSee) {
                    return;
                }
                this.sendPacket((Player)connected, packet, isNameTagEmpty);
            }
            catch (Throwable e) {
                this.plugin.log(Level.ERROR, "Failed to dispatch packet (unsupported client or server version)", e);
            }
        });
    }

    private void sendPacket(@NotNull Player player, @NotNull UpdateTeamsPacket packet, boolean isNameTagEmpty) {
        if (!player.isActive()) {
            this.plugin.getTabList().removeOfflinePlayer(player);
            return;
        }
        if (player.getProtocolVersion().noLessThan((Object)ProtocolVersion.MINECRAFT_1_21_2) && isNameTagEmpty) {
            return;
        }
        ConnectedPlayer connectedPlayer = (ConnectedPlayer)player;
        connectedPlayer.getConnection().write((Object)packet);
    }

    public void registerPacket() {
        if (!this.teams) {
            return;
        }
        try {
            this.packetRegistration = PacketRegistration.of(UpdateTeamsPacket.class).direction(ProtocolUtils.Direction.CLIENTBOUND).packetSupplier(() -> new UpdateTeamsPacket(this.plugin)).stateRegistry(StateRegistry.PLAY).mapping(62, ProtocolVersion.MINECRAFT_1_8, false).mapping(68, ProtocolVersion.MINECRAFT_1_12_2, false).mapping(71, ProtocolVersion.MINECRAFT_1_13, false).mapping(75, ProtocolVersion.MINECRAFT_1_14, false).mapping(76, ProtocolVersion.MINECRAFT_1_15, false).mapping(85, ProtocolVersion.MINECRAFT_1_17, false).mapping(88, ProtocolVersion.MINECRAFT_1_19_1, false).mapping(86, ProtocolVersion.MINECRAFT_1_19_3, false).mapping(90, ProtocolVersion.MINECRAFT_1_19_4, false).mapping(92, ProtocolVersion.MINECRAFT_1_20_2, false).mapping(94, ProtocolVersion.MINECRAFT_1_20_3, false).mapping(96, ProtocolVersion.MINECRAFT_1_20_5, false).mapping(103, ProtocolVersion.MINECRAFT_1_21_2, false).mapping(102, ProtocolVersion.MINECRAFT_1_21_5, false).mapping(107, ProtocolVersion.MINECRAFT_1_21_9, false);
            this.packetRegistration.register();
        }
        catch (Throwable e) {
            this.plugin.log(Level.ERROR, "Failed to register UpdateTeamsPacket", e);
        }
    }

    public void unregisterPacket() {
        if (this.packetRegistration == null) {
            return;
        }
        try {
            this.packetRegistration.unregister();
        }
        catch (Throwable e) {
            this.plugin.log(Level.ERROR, "Failed to unregister UpdateTeamsPacket", e);
        }
    }

    public void recalculateVanishForPlayer(TabPlayer tabPlayer, TabPlayer target, boolean canSee) {
        Nametag tag;
        if (!this.teams) {
            return;
        }
        Player player = tabPlayer.getPlayer();
        String team = this.createdTeams.get(target.getPlayer().getUniqueId());
        if (team == null) {
            return;
        }
        UpdateTeamsPacket removeTeam = UpdateTeamsPacket.removeTeam(this.plugin, team);
        boolean isNameTagEmpty = tabPlayer.getGroup().nametag().isEmpty() && !this.plugin.getSettings().isRemoveNametags();
        this.sendPacket(player, removeTeam, isNameTagEmpty);
        this.trackedTeams.remove((Object)player.getUniqueId(), (Object)team);
        if (canSee && (tag = this.nametags.get(team)) != null) {
            this.dispatchCreatePacket(this.plugin, tabPlayer, team, tag, target, target.getPlayer().getUsername());
        }
    }

    @Generated
    public Map<UUID, String> getCreatedTeams() {
        return this.createdTeams;
    }

    @Generated
    public SortedSet getSortedTeams() {
        return this.sortedTeams;
    }
}

