/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.placeholder;

import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.libraries.annotations.Nullable;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.util.TriFunction;

public enum Placeholder {
    PLAYERS_ONLINE((plugin, player) -> Integer.toString(plugin.getServer().getPlayerCount())),
    MAX_PLAYERS_ONLINE((plugin, player) -> Integer.toString(plugin.getServer().getConfiguration().getShowMaxPlayers())),
    LOCAL_PLAYERS_ONLINE((plugin, player) -> player.getPlayer().getCurrentServer().map(ServerConnection::getServer).map(RegisteredServer::getPlayersConnected).map(players -> Integer.toString(players.size())).orElse("")),
    GROUP_PLAYERS_ONLINE((param, plugin, player) -> {
        if (param == null) {
            return Integer.toString(player.getGroup().getTabPlayers((Velocitab)plugin).size());
        }
        return plugin.getTabGroupsManager().getGroup((String)param).map(group -> Integer.toString(group.getPlayers((Velocitab)plugin).size())).orElse("Group " + param + " not found");
    }),
    CURRENT_DATE_DAY((plugin, player) -> DateTimeFormatter.ofPattern("dd").format(LocalDateTime.now())),
    CURRENT_DATE_WEEKDAY((param, plugin, player) -> {
        if (param == null) {
            return DateTimeFormatter.ofPattern("EEEE").format(LocalDateTime.now());
        }
        String countryCode = param.toUpperCase();
        Locale locale = Locale.forLanguageTag(countryCode);
        return DateTimeFormatter.ofPattern("EEEE").withLocale(locale).format(LocalDateTime.now());
    }),
    CURRENT_DATE_MONTH((plugin, player) -> DateTimeFormatter.ofPattern("MM").format(LocalDateTime.now())),
    CURRENT_DATE_YEAR((plugin, player) -> DateTimeFormatter.ofPattern("yyyy").format(LocalDateTime.now())),
    CURRENT_DATE((param, plugin, player) -> {
        if (param == null) {
            return DateTimeFormatter.ofPattern("dd/MM/yyyy").format(LocalDateTime.now());
        }
        String countryCode = param.toUpperCase();
        Locale locale = Locale.forLanguageTag(countryCode);
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(locale).format(LocalDateTime.now());
    }),
    CURRENT_TIME_HOUR((plugin, player) -> DateTimeFormatter.ofPattern("HH").format(LocalDateTime.now())),
    CURRENT_TIME_MINUTE((plugin, player) -> DateTimeFormatter.ofPattern("mm").format(LocalDateTime.now())),
    CURRENT_TIME_SECOND((plugin, player) -> DateTimeFormatter.ofPattern("ss").format(LocalDateTime.now())),
    CURRENT_TIME((param, plugin, player) -> {
        if (param == null) {
            return DateTimeFormatter.ofPattern("HH:mm:ss").format(LocalTime.now());
        }
        String countryCode = param.toUpperCase();
        Locale locale = Locale.forLanguageTag(countryCode);
        return DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale).format(LocalTime.now());
    }),
    USERNAME((plugin, player) -> player.getCustomName().orElse(player.getPlayer().getUsername())),
    USERNAME_LOWER((plugin, player) -> player.getCustomName().orElse(player.getPlayer().getUsername()).toLowerCase()),
    SERVER((plugin, player) -> player.getServerName()),
    PING((plugin, player) -> Long.toString(player.getPlayer().getPing())),
    PREFIX((plugin, player) -> player.getRole().getPrefix().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_prefix%"))),
    SUFFIX((plugin, player) -> player.getRole().getSuffix().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_suffix%"))),
    ROLE((plugin, player) -> player.getRole().getName().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_primary_group_name%"))),
    ROLE_DISPLAY_NAME((plugin, player) -> player.getRole().getDisplayName().orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_primary_group_name%"))),
    ROLE_WEIGHT((plugin, player) -> plugin.getLuckPermsHook().map(hook -> player.getRoleWeightString()).orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_meta_weight%"))),
    SERVER_GROUP((plugin, player) -> player.getGroup().name()),
    SERVER_GROUP_INDEX((plugin, player) -> Integer.toString(player.getServerGroupPosition((Velocitab)plugin))),
    SERVER_ONLINE_PLAYERS((param, plugin, player) -> {
        if (param == null) {
            return Integer.toString(player.getPlayer().getCurrentServer().map(ServerConnection::getServer).map(RegisteredServer::getPlayersConnected).map(Collection::size).orElse(0));
        }
        return Integer.toString(plugin.getServer().getServer(param).map(RegisteredServer::getPlayersConnected).map(Collection::size).orElse(0));
    }),
    DEBUG_TEAM_NAME((plugin, player) -> plugin.getFormatter().escape(player.getLastTeamName().orElse(""))),
    LUCKPERMS_META((param, plugin, player) -> plugin.getLuckPermsHook().map(hook -> hook.getMeta(player.getPlayer(), (String)param)).orElse(Placeholder.getPlaceholderFallback(plugin, "%luckperms_meta_" + param + "%"))),
    BACKEND_LUCKPERMS_META_WEIGHT((plugin, player) -> "%luckperms_meta_weight%", true),
    BACKEND_LUCKPERMS_PREFIX((plugin, player) -> "%luckperms_prefix%", true),
    BACKEND_LUCKPERMS_SUFFIX((plugin, player) -> "%luckperms_suffix%", true);

    private static final List<Placeholder> VALUES;
    private static final Map<String, Placeholder> BY_NAME;
    private static final List<Placeholder> PARAMETERISED;
    private final TriFunction<@Nullable String, @NotNull Velocitab, @NotNull TabPlayer, @NotNull String> replacer;
    private final boolean parameterised;
    private final boolean forBackend;
    private final Pattern pattern;

    private Placeholder(BiFunction<Velocitab, TabPlayer, String> replacer) {
        this.parameterised = false;
        this.forBackend = false;
        this.replacer = (text, player, plugin) -> (String)replacer.apply((Velocitab)player, (TabPlayer)plugin);
        this.pattern = Pattern.compile("%" + this.name().toLowerCase() + "%");
    }

    private Placeholder(BiFunction<Velocitab, TabPlayer, String> replacer, boolean forBackend) {
        this.parameterised = false;
        this.forBackend = forBackend;
        this.replacer = (text, player, plugin) -> (String)replacer.apply((Velocitab)player, (TabPlayer)plugin);
        this.pattern = Pattern.compile("%" + this.name().toLowerCase() + "%");
    }

    private Placeholder(TriFunction<String, Velocitab, TabPlayer, String> parameterisedReplacer) {
        this.parameterised = true;
        this.forBackend = false;
        this.replacer = parameterisedReplacer;
        this.pattern = Pattern.compile("%" + this.name().toLowerCase() + "[^%]*%", 2);
    }

    @NotNull
    private static String getPlaceholderFallback(@NotNull Velocitab plugin, @NotNull String fallback) {
        if (plugin.getPAPIProxyBridgeHook().isPresent() && plugin.getSettings().isFallbackToPapiIfPlaceholderBlank()) {
            return fallback;
        }
        return "";
    }

    public static Optional<Placeholder> byName(@NotNull String name) {
        return Optional.ofNullable(BY_NAME.get(name.toLowerCase().replace("%", "")));
    }

    @Generated
    public TriFunction<@Nullable String, @NotNull Velocitab, @NotNull TabPlayer, @NotNull String> getReplacer() {
        return this.replacer;
    }

    @Generated
    public boolean isParameterised() {
        return this.parameterised;
    }

    @Generated
    public boolean isForBackend() {
        return this.forBackend;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    @Generated
    public static List<Placeholder> getPARAMETERISED() {
        return PARAMETERISED;
    }

    static {
        VALUES = Arrays.asList(Placeholder.values());
        BY_NAME = VALUES.stream().collect(Collectors.toMap(p -> p.name().toLowerCase(), Function.identity()));
        PARAMETERISED = VALUES.stream().filter(p -> p.parameterised).toList();
    }
}

