/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.hook;

import com.velocitypowered.api.proxy.Player;
import io.github.miniplaceholders.api.Expansion;
import io.github.miniplaceholders.api.MiniPlaceholders;
import io.github.miniplaceholders.api.utils.TagsUtils;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Placeholder;
import net.william278.velocitab.hook.miniconditions.MiniConditionManager;
import net.william278.velocitab.player.TabPlayer;

public class VelocitabMiniExpansion {
    private final Velocitab plugin;
    private final MiniConditionManager miniConditionManager;
    private Expansion expansion;

    public VelocitabMiniExpansion(Velocitab plugin) {
        this.plugin = plugin;
        this.miniConditionManager = new MiniConditionManager(plugin);
    }

    public void registerExpansion() {
        Expansion.Builder builder = Expansion.builder((String)"velocitab");
        builder.relationalPlaceholder("condition", (a1, a2, queue, ctx) -> {
            if (!(a2 instanceof Player)) {
                return TagsUtils.EMPTY_TAG;
            }
            Player target = (Player)a2;
            if (!(a1 instanceof Player)) {
                return TagsUtils.EMPTY_TAG;
            }
            Player audience = (Player)a1;
            return Tag.selfClosingInserting((Component)this.miniConditionManager.checkConditions(target, audience, queue));
        });
        builder.relationalPlaceholder("who-is-seeing", (a1, a2, queue, ctx) -> {
            if (!(a2 instanceof Player)) {
                return TagsUtils.EMPTY_TAG;
            }
            Player target = (Player)a2;
            if (!(a1 instanceof Player)) {
                return TagsUtils.EMPTY_TAG;
            }
            return Tag.selfClosingInserting((Component)Component.text((String)target.getUsername()));
        });
        builder.relationalPlaceholder("perm", (a1, a2, queue, ctx) -> {
            if (!(a2 instanceof Player)) {
                return TagsUtils.EMPTY_TAG;
            }
            Player target = (Player)a2;
            if (!(a1 instanceof Player)) {
                return TagsUtils.EMPTY_TAG;
            }
            Player audience = (Player)a1;
            Optional<TabPlayer> targetOptional = this.plugin.getTabList().getTabPlayer(audience);
            if (targetOptional.isEmpty()) {
                return TagsUtils.EMPTY_TAG;
            }
            TabPlayer targetPlayer = targetOptional.get();
            if (!queue.hasNext()) {
                return TagsUtils.EMPTY_TAG;
            }
            String permission = queue.pop().value();
            if (!queue.hasNext()) {
                return TagsUtils.EMPTY_TAG;
            }
            if (!target.hasPermission(permission)) {
                return TagsUtils.EMPTY_TAG;
            }
            String value = queue.pop().value();
            String replaced = Placeholder.replaceInternal(value, this.plugin, targetPlayer);
            for (Map.Entry<String, String> entry : Placeholder.SYMBOL_SUBSTITUTES.entrySet()) {
                replaced = replaced.replace(entry.getValue(), entry.getKey());
            }
            return Tag.selfClosingInserting((Component)MiniMessage.miniMessage().deserialize(replaced, MiniPlaceholders.getAudienceGlobalPlaceholders((Audience)audience)));
        });
        builder.relationalPlaceholder("vanish", (a1, otherAudience, queue, ctx) -> {
            if (!(otherAudience instanceof Player)) {
                return TagsUtils.EMPTY_TAG;
            }
            Player target = (Player)otherAudience;
            if (!(a1 instanceof Player)) {
                return TagsUtils.EMPTY_TAG;
            }
            Player audience = (Player)a1;
            return Tag.selfClosingInserting((Component)Component.text((boolean)this.plugin.getVanishManager().getIntegration().canSee(audience.getUsername(), target.getUsername())));
        });
        this.plugin.getLogger().info("Registered Velocitab MiniExpansion");
        this.expansion = (Expansion)builder.build();
        this.expansion.register();
    }

    public void unregisterExpansion() {
        this.expansion.unregister();
    }
}

