/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.commons.jexl3.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.william278.velocitab.libraries.commons.jexl3.JexlExpression;
import net.william278.velocitab.libraries.commons.jexl3.JexlFeatures;
import net.william278.velocitab.libraries.commons.jexl3.JexlInfo;
import net.william278.velocitab.libraries.commons.jexl3.JexlScript;
import net.william278.velocitab.libraries.commons.jexl3.internal.LexicalScope;
import net.william278.velocitab.libraries.commons.jexl3.internal.Scope;
import net.william278.velocitab.libraries.commons.jexl3.internal.Script;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTAddNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTAndNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTAnnotatedStatement;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTAnnotation;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTArguments;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTArrayAccess;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTArrayLiteral;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTAssignment;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTBitwiseAndNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTBitwiseComplNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTBitwiseOrNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTBitwiseXorNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTBlock;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTBreak;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTConstructorNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTContinue;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTDecrementGetNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTDefineVars;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTDivNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTDoWhileStatement;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTEQNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTEQSNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTERNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTEWNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTEmptyFunction;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTExtendedLiteral;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTFalseNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTForeachStatement;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTFunctionNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTGENode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTGTNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTGetDecrementNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTGetIncrementNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTIdentifier;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTIdentifierAccess;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTIfStatement;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTIncrementGetNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTInstanceOf;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTJexlLambda;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTJexlScript;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTJxltLiteral;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTLENode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTLTNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTMapEntry;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTMapLiteral;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTMethodNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTModNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTMulNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNENode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNESNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNEWNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNRNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNSWNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNotInstanceOf;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNotNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNullLiteral;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNullpNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTNumberLiteral;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTOrNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTQualifiedIdentifier;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTRangeNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTReference;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTReferenceExpression;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTRegexLiteral;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTReturnStatement;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSWNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetAddNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetAndNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetDivNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetLiteral;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetModNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetMultNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetOrNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetShiftLeftNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetShiftRightNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetShiftRightUnsignedNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetSubNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSetXorNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTShiftLeftNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTShiftRightNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTShiftRightUnsignedNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSizeFunction;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTStringLiteral;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTSubNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTTernaryNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTThrowStatement;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTTrueNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTTryResources;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTTryStatement;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTUnaryMinusNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTUnaryPlusNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTVar;
import net.william278.velocitab.libraries.commons.jexl3.parser.ASTWhileStatement;
import net.william278.velocitab.libraries.commons.jexl3.parser.JexlNode;
import net.william278.velocitab.libraries.commons.jexl3.parser.ParserVisitor;
import net.william278.velocitab.libraries.commons.jexl3.parser.StringParser;

public class Debugger
extends ParserVisitor
implements JexlInfo.Detail {
    protected static final Pattern QUOTED_IDENTIFIER = Pattern.compile("\\s|\\p{Punct}&&[^@#$_]");
    protected final StringBuilder builder = new StringBuilder();
    protected JexlNode cause;
    protected int start;
    protected int end;
    protected int indentLevel;
    protected int indent = 2;
    protected int depth = Integer.MAX_VALUE;
    protected String arrow = "->";
    protected String lf = "\n";
    protected boolean outputPragmas;

    private static boolean isLambdaExpr(ASTJexlLambda lambda) {
        return lambda.jjtGetNumChildren() == 1 && !Debugger.isStatement(lambda.jjtGetChild(0));
    }

    private static boolean isStatement(JexlNode child) {
        return child instanceof ASTJexlScript || child instanceof ASTBlock || child instanceof ASTIfStatement || child instanceof ASTForeachStatement || child instanceof ASTTryStatement || child instanceof ASTWhileStatement || child instanceof ASTDoWhileStatement || child instanceof ASTAnnotation || child instanceof ASTThrowStatement;
    }

    private static boolean semicolTerminated(CharSequence cs) {
        for (int i = cs.length() - 1; i >= 0; --i) {
            char c = cs.charAt(i);
            if (c == ';') {
                return true;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return false;
    }

    private static void writePragmas(StringBuilder builder, Map<String, Object> pragmas) {
        if (pragmas != null) {
            for (Map.Entry<String, Object> pragma : pragmas.entrySet()) {
                String key = pragma.getKey();
                Object value = pragma.getValue();
                Set<Object> values = value instanceof Set ? (Set<Object>)value : Collections.singleton(value);
                for (Object pragmaValue : values) {
                    builder.append("#pragma ");
                    builder.append(key);
                    builder.append(' ');
                    builder.append(pragmaValue.toString());
                    builder.append('\n');
                }
            }
        }
    }

    protected Object accept(JexlNode node, Object data) {
        if (this.depth <= 0 && this.builder.length() > 0) {
            this.builder.append("...");
            return data;
        }
        if (node == this.cause) {
            this.start = this.builder.length();
        }
        --this.depth;
        Object value = node.jjtAccept(this, data);
        ++this.depth;
        if (node == this.cause) {
            this.end = this.builder.length();
        }
        return value;
    }

    protected Object acceptStatement(JexlNode child, Object data) {
        JexlNode parent = child.jjtGetParent();
        if (this.indent > 0 && (parent instanceof ASTBlock || parent instanceof ASTJexlScript)) {
            for (int i = 0; i < this.indentLevel; ++i) {
                for (int s = 0; s < this.indent; ++s) {
                    this.builder.append(' ');
                }
            }
        }
        --this.depth;
        Object value = this.accept(child, data);
        ++this.depth;
        if (!Debugger.isStatement(child) && !Debugger.semicolTerminated(this.builder)) {
            this.builder.append(';');
            if (this.indent > 0) {
                this.builder.append(this.lf);
            } else {
                this.builder.append(' ');
            }
        }
        return value;
    }

    protected Object additiveNode(JexlNode node, String op, Object data) {
        boolean paren = node.jjtGetParent() instanceof ASTMulNode || node.jjtGetParent() instanceof ASTDivNode || node.jjtGetParent() instanceof ASTModNode;
        int num = node.jjtGetNumChildren();
        if (paren) {
            this.builder.append('(');
        }
        this.accept(node.jjtGetChild(0), data);
        for (int i = 1; i < num; ++i) {
            this.builder.append(op);
            this.accept(node.jjtGetChild(i), data);
        }
        if (paren) {
            this.builder.append(')');
        }
        return data;
    }

    protected Object check(JexlNode node, String image, Object data) {
        if (node == this.cause) {
            this.start = this.builder.length();
        }
        if (image != null) {
            this.builder.append(image);
        } else {
            this.builder.append(node.toString());
        }
        if (node == this.cause) {
            this.end = this.builder.length();
        }
        return data;
    }

    public String data(JexlNode node) {
        this.start = 0;
        this.end = 0;
        this.indentLevel = 0;
        this.setArrowSymbol(node);
        if (node != null) {
            this.builder.setLength(0);
            this.cause = node;
            this.accept(node, null);
        }
        return this.builder.toString();
    }

    public boolean debug(JexlExpression jscript) {
        if (jscript instanceof Script) {
            Script script = (Script)jscript;
            return this.debug(script.script);
        }
        return false;
    }

    public boolean debug(JexlNode node) {
        return this.debug(node, true);
    }

    public boolean debug(JexlNode node, boolean r) {
        this.start = 0;
        this.end = 0;
        this.indentLevel = 0;
        this.setArrowSymbol(node);
        if (node != null) {
            this.builder.setLength(0);
            this.cause = node;
            JexlNode walk = node;
            if (r) {
                while (walk.jjtGetParent() != null) {
                    walk = walk.jjtGetParent();
                }
            }
            this.accept(walk, null);
        }
        return this.end > 0;
    }

    public boolean debug(JexlScript jscript) {
        if (jscript instanceof Script) {
            Script script = (Script)jscript;
            return this.debug(script.script);
        }
        return false;
    }

    public Debugger depth(int rdepth) {
        this.depth = rdepth;
        return this;
    }

    @Override
    public int end() {
        return this.end;
    }

    protected JexlFeatures getFeatures(JexlNode node) {
        for (JexlNode walk = node; walk != null; walk = walk.jjtGetParent()) {
            if (!(walk instanceof ASTJexlScript)) continue;
            ASTJexlScript script = (ASTJexlScript)walk;
            return script.getFeatures();
        }
        return null;
    }

    public Debugger indentation(int level) {
        this.indent = Math.max(level, 0);
        this.indentLevel = 0;
        return this;
    }

    protected Object infixChildren(JexlNode node, String infix, boolean paren, Object data) {
        int num = node.jjtGetNumChildren();
        if (paren) {
            this.builder.append('(');
        }
        for (int i = 0; i < num; ++i) {
            if (i > 0) {
                this.builder.append(infix);
            }
            this.accept(node.jjtGetChild(i), data);
        }
        if (paren) {
            this.builder.append(')');
        }
        return data;
    }

    public Debugger lineFeed(String lf) {
        this.lf = lf;
        return this;
    }

    protected boolean needQuotes(String str) {
        return QUOTED_IDENTIFIER.matcher(str).find() || "size".equals(str) || "empty".equals(str);
    }

    public Debugger outputPragmas(boolean flag) {
        this.outputPragmas = flag;
        return this;
    }

    protected Object postfixChild(JexlNode node, String prefix, Object data) {
        boolean paren;
        boolean bl = paren = node.jjtGetChild(0).jjtGetNumChildren() > 1;
        if (paren) {
            this.builder.append('(');
        }
        this.accept(node.jjtGetChild(0), data);
        if (paren) {
            this.builder.append(')');
        }
        this.builder.append(prefix);
        return data;
    }

    protected Object prefixChild(JexlNode node, String prefix, Object data) {
        boolean paren = node.jjtGetChild(0).jjtGetNumChildren() > 1;
        this.builder.append(prefix);
        if (paren) {
            this.builder.append('(');
        }
        this.accept(node.jjtGetChild(0), data);
        if (paren) {
            this.builder.append(')');
        }
        return data;
    }

    public void reset() {
        this.builder.setLength(0);
        this.cause = null;
        this.start = 0;
        this.end = 0;
        this.indentLevel = 0;
        this.indent = 2;
        this.depth = Integer.MAX_VALUE;
    }

    protected void setArrowSymbol(JexlNode node) {
        JexlFeatures features = this.getFeatures(node);
        this.arrow = features != null && features.supportsFatArrow() && !features.supportsThinArrow() ? "=>" : "->";
    }

    public void setIndentation(int level) {
        this.indentation(level);
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public String toString() {
        return this.builder.toString();
    }

    @Override
    protected Object visit(ASTAddNode node, Object data) {
        return this.additiveNode(node, " + ", data);
    }

    @Override
    protected Object visit(ASTAndNode node, Object data) {
        return this.infixChildren(node, " && ", false, data);
    }

    @Override
    protected Object visit(ASTAnnotatedStatement node, Object data) {
        int num = node.jjtGetNumChildren();
        for (int i = 0; i < num; ++i) {
            if (i > 0) {
                this.builder.append(' ');
            }
            JexlNode child = node.jjtGetChild(i);
            this.acceptStatement(child, data);
        }
        return data;
    }

    @Override
    protected Object visit(ASTAnnotation node, Object data) {
        int num = node.jjtGetNumChildren();
        this.builder.append('@');
        this.builder.append(node.getName());
        if (num > 0) {
            this.accept(node.jjtGetChild(0), data);
        }
        return null;
    }

    @Override
    protected Object visit(ASTArguments node, Object data) {
        int num = node.jjtGetNumChildren();
        this.builder.append("(");
        if (num > 0) {
            this.accept(node.jjtGetChild(0), data);
            for (int i = 1; i < num; ++i) {
                this.builder.append(", ");
                this.accept(node.jjtGetChild(i), data);
            }
        }
        this.builder.append(")");
        return data;
    }

    @Override
    protected Object visit(ASTArrayAccess node, Object data) {
        int num = node.jjtGetNumChildren();
        for (int i = 0; i < num; ++i) {
            if (node.isSafeChild(i)) {
                this.builder.append('?');
            }
            this.builder.append('[');
            this.accept(node.jjtGetChild(i), data);
            this.builder.append(']');
        }
        return data;
    }

    @Override
    protected Object visit(ASTArrayLiteral node, Object data) {
        int num = node.jjtGetNumChildren();
        this.builder.append("[ ");
        if (num > 0) {
            if (this.depth <= 0) {
                this.builder.append("...");
            } else {
                this.accept(node.jjtGetChild(0), data);
                for (int i = 1; i < num; ++i) {
                    this.builder.append(", ");
                    this.accept(node.jjtGetChild(i), data);
                }
            }
        }
        this.builder.append(" ]");
        return data;
    }

    @Override
    protected Object visit(ASTAssignment node, Object data) {
        return this.infixChildren(node, " = ", false, data);
    }

    @Override
    protected Object visit(ASTBitwiseAndNode node, Object data) {
        return this.infixChildren(node, " & ", false, data);
    }

    @Override
    protected Object visit(ASTBitwiseComplNode node, Object data) {
        return this.prefixChild(node, "~", data);
    }

    @Override
    protected Object visit(ASTBitwiseOrNode node, Object data) {
        boolean paren = node.jjtGetParent() instanceof ASTBitwiseAndNode;
        return this.infixChildren(node, " | ", paren, data);
    }

    @Override
    protected Object visit(ASTBitwiseXorNode node, Object data) {
        boolean paren = node.jjtGetParent() instanceof ASTBitwiseAndNode;
        return this.infixChildren(node, " ^ ", paren, data);
    }

    @Override
    protected Object visit(ASTBlock node, Object data) {
        int i;
        this.builder.append('{');
        if (this.indent > 0) {
            ++this.indentLevel;
            this.builder.append(this.lf);
        } else {
            this.builder.append(' ');
        }
        int num = node.jjtGetNumChildren();
        for (i = 0; i < num; ++i) {
            JexlNode child = node.jjtGetChild(i);
            this.acceptStatement(child, data);
        }
        if (this.indent > 0) {
            --this.indentLevel;
            for (i = 0; i < this.indentLevel; ++i) {
                for (int s = 0; s < this.indent; ++s) {
                    this.builder.append(' ');
                }
            }
        }
        if (!Character.isSpaceChar(this.builder.charAt(this.builder.length() - 1))) {
            this.builder.append(' ');
        }
        this.builder.append('}');
        return data;
    }

    @Override
    protected Object visit(ASTBreak node, Object data) {
        return this.check(node, "break", data);
    }

    @Override
    protected Object visit(ASTConstructorNode node, Object data) {
        int num = node.jjtGetNumChildren();
        this.builder.append("new");
        if (num > 0) {
            JexlNode c0 = node.jjtGetChild(0);
            boolean first = true;
            if (c0 instanceof ASTQualifiedIdentifier) {
                this.builder.append(' ');
                this.accept(c0, data);
                this.builder.append('(');
            } else {
                first = false;
                this.builder.append('(');
                this.accept(c0, data);
            }
            for (int i = 1; i < num; ++i) {
                if (!first) {
                    this.builder.append(", ");
                }
                this.accept(node.jjtGetChild(i), data);
            }
        }
        this.builder.append(")");
        return data;
    }

    @Override
    protected Object visit(ASTContinue node, Object data) {
        return this.check(node, "continue", data);
    }

    @Override
    protected Object visit(ASTDecrementGetNode node, Object data) {
        return this.prefixChild(node, "--", data);
    }

    @Override
    protected Object visit(ASTDefineVars node, Object data) {
        int num = node.jjtGetNumChildren();
        if (num > 0) {
            this.accept(node.jjtGetChild(0), data);
            for (int i = 1; i < num; ++i) {
                this.builder.append(", ");
                JexlNode child = node.jjtGetChild(i);
                if (child instanceof ASTAssignment) {
                    ASTAssignment assign = (ASTAssignment)child;
                    int nc = assign.jjtGetNumChildren();
                    ASTVar avar = (ASTVar)assign.jjtGetChild(0);
                    this.builder.append(avar.getName());
                    if (nc <= 1) continue;
                    this.builder.append(" = ");
                    this.accept(assign.jjtGetChild(1), data);
                    continue;
                }
                if (child instanceof ASTVar) {
                    ASTVar avar = (ASTVar)child;
                    this.builder.append(avar.getName());
                    continue;
                }
                this.accept(child, data);
            }
        }
        return data;
    }

    @Override
    protected Object visit(ASTDivNode node, Object data) {
        return this.infixChildren(node, " / ", false, data);
    }

    @Override
    protected Object visit(ASTDoWhileStatement node, Object data) {
        this.builder.append("do ");
        int nc = node.jjtGetNumChildren();
        if (nc > 1) {
            this.acceptStatement(node.jjtGetChild(0), data);
        } else {
            this.builder.append(";");
        }
        this.builder.append(" while (");
        this.accept(node.jjtGetChild(nc - 1), data);
        this.builder.append(")");
        return data;
    }

    @Override
    protected Object visit(ASTEmptyFunction node, Object data) {
        this.builder.append("empty ");
        this.accept(node.jjtGetChild(0), data);
        return data;
    }

    @Override
    protected Object visit(ASTEQNode node, Object data) {
        return this.infixChildren(node, " == ", false, data);
    }

    @Override
    protected Object visit(ASTEQSNode node, Object data) {
        return this.infixChildren(node, " === ", false, data);
    }

    @Override
    protected Object visit(ASTERNode node, Object data) {
        return this.infixChildren(node, " =~ ", false, data);
    }

    @Override
    protected Object visit(ASTEWNode node, Object data) {
        return this.infixChildren(node, " =$ ", false, data);
    }

    @Override
    protected Object visit(ASTExtendedLiteral node, Object data) {
        this.builder.append("...");
        return data;
    }

    @Override
    protected Object visit(ASTFalseNode node, Object data) {
        return this.check(node, "false", data);
    }

    @Override
    protected Object visit(ASTForeachStatement node, Object data) {
        JexlNode body;
        int form = node.getLoopForm();
        this.builder.append("for(");
        if (form == 0) {
            this.accept(node.jjtGetChild(0), data);
            this.builder.append(" : ");
            this.accept(node.jjtGetChild(1), data);
            this.builder.append(") ");
            body = node.jjtGetNumChildren() > 2 ? node.jjtGetChild(2) : null;
        } else {
            int nc = 0;
            JexlNode vars = (form & 1) != 0 ? node.jjtGetChild(nc++) : null;
            JexlNode predicate = (form & 2) != 0 ? node.jjtGetChild(nc++) : null;
            JexlNode step = (form & 4) != 0 ? node.jjtGetChild(nc++) : null;
            JexlNode jexlNode = body = (form & 8) != 0 ? node.jjtGetChild(nc) : null;
            if (vars != null) {
                this.accept(vars, data);
            }
            this.builder.append("; ");
            if (predicate != null) {
                this.accept(predicate, data);
            }
            this.builder.append("; ");
            if (step != null) {
                this.accept(step, data);
            }
            this.builder.append(") ");
        }
        if (body != null) {
            this.accept(body, data);
        } else {
            this.builder.append(';');
        }
        return data;
    }

    @Override
    protected Object visit(ASTFunctionNode node, Object data) {
        int num = node.jjtGetNumChildren();
        if (num == 3) {
            this.accept(node.jjtGetChild(0), data);
            this.builder.append(":");
            this.accept(node.jjtGetChild(1), data);
            this.accept(node.jjtGetChild(2), data);
        } else if (num == 2) {
            this.accept(node.jjtGetChild(0), data);
            this.accept(node.jjtGetChild(1), data);
        }
        return data;
    }

    @Override
    protected Object visit(ASTGENode node, Object data) {
        return this.infixChildren(node, " >= ", false, data);
    }

    @Override
    protected Object visit(ASTGetDecrementNode node, Object data) {
        return this.postfixChild(node, "--", data);
    }

    @Override
    protected Object visit(ASTGetIncrementNode node, Object data) {
        return this.postfixChild(node, "++", data);
    }

    @Override
    protected Object visit(ASTGTNode node, Object data) {
        return this.infixChildren(node, " > ", false, data);
    }

    @Override
    protected Object visit(ASTIdentifier node, Object data) {
        String ns = node.getNamespace();
        String image = StringParser.escapeIdentifier(node.getName());
        if (ns == null) {
            return this.check(node, image, data);
        }
        String nsid = StringParser.escapeIdentifier(ns) + ":" + image;
        return this.check(node, nsid, data);
    }

    @Override
    protected Object visit(ASTIdentifierAccess node, Object data) {
        this.builder.append(node.isSafe() ? "?." : ".");
        String image = node.getName();
        if (node.isExpression()) {
            this.builder.append('`');
            this.builder.append(image.replace("`", "\\`"));
            this.builder.append('`');
        } else if (this.needQuotes(image)) {
            this.builder.append('\'');
            this.builder.append(image.replace("'", "\\'"));
            this.builder.append('\'');
        } else {
            this.builder.append(image);
        }
        return data;
    }

    @Override
    protected Object visit(ASTIfStatement node, Object data) {
        int numChildren = node.jjtGetNumChildren();
        this.builder.append("if (");
        this.accept(node.jjtGetChild(0), data);
        this.builder.append(") ");
        this.acceptStatement(node.jjtGetChild(1), data);
        for (int c = 2; c < numChildren - 1; c += 2) {
            this.builder.append(" else if (");
            this.accept(node.jjtGetChild(c), data);
            this.builder.append(") ");
            this.acceptStatement(node.jjtGetChild(c + 1), data);
        }
        if ((numChildren & 1) == 1) {
            this.builder.append(" else ");
            this.acceptStatement(node.jjtGetChild(numChildren - 1), data);
        }
        return data;
    }

    @Override
    protected Object visit(ASTIncrementGetNode node, Object data) {
        return this.prefixChild(node, "++", data);
    }

    @Override
    protected Object visit(ASTInstanceOf node, Object data) {
        return this.infixChildren(node, " instanceof ", false, data);
    }

    @Override
    protected Object visit(ASTJexlScript node, Object arg) {
        int num;
        if (this.outputPragmas) {
            Debugger.writePragmas(this.builder, node.getPragmas());
        }
        Object data = arg;
        boolean named = false;
        if (node instanceof ASTJexlLambda) {
            boolean assigned;
            ASTJexlLambda lambda = (ASTJexlLambda)node;
            JexlNode parent = node.jjtGetParent();
            boolean expr = Debugger.isLambdaExpr(lambda);
            named = node.jjtGetChild(0) instanceof ASTVar;
            boolean bl = assigned = parent instanceof ASTAssignment || named;
            if (assigned && !expr) {
                this.builder.append("function");
                if (named) {
                    ASTVar avar = (ASTVar)node.jjtGetChild(0);
                    this.builder.append(' ');
                    this.builder.append(avar.getName());
                }
            }
            this.builder.append('(');
            String[] params = lambda.getParameters();
            if (params != null) {
                Scope scope = lambda.getScope();
                LexicalScope lexicalScope = lambda.getLexicalScope();
                for (int p = 0; p < params.length; ++p) {
                    String param;
                    int symbol;
                    if (p > 0) {
                        this.builder.append(", ");
                    }
                    if (lexicalScope.isConstant(symbol = scope.getSymbol(param = params[p]).intValue())) {
                        this.builder.append("const ");
                    } else if (scope.isLexical(symbol)) {
                        this.builder.append("let ");
                    }
                    this.builder.append(this.visitParameter(param, data));
                }
            }
            this.builder.append(')');
            if (assigned && !expr) {
                this.builder.append(' ');
            } else {
                this.builder.append(this.arrow);
                if (expr) {
                    this.builder.append(' ');
                }
            }
        }
        if ((num = node.jjtGetNumChildren()) == 1 && !(node instanceof ASTJexlLambda)) {
            data = this.accept(node.jjtGetChild(0), data);
        } else {
            int i;
            int n = i = named ? 1 : 0;
            while (i < num) {
                JexlNode child = node.jjtGetChild(i);
                this.acceptStatement(child, data);
                ++i;
            }
        }
        return data;
    }

    @Override
    protected Object visit(ASTJxltLiteral node, Object data) {
        String img = StringParser.escapeString(node.getLiteral(), '`');
        return this.check(node, img, data);
    }

    @Override
    protected Object visit(ASTLENode node, Object data) {
        return this.infixChildren(node, " <= ", false, data);
    }

    @Override
    protected Object visit(ASTLTNode node, Object data) {
        return this.infixChildren(node, " < ", false, data);
    }

    @Override
    protected Object visit(ASTMapEntry node, Object data) {
        this.accept(node.jjtGetChild(0), data);
        this.builder.append(" : ");
        this.accept(node.jjtGetChild(1), data);
        return data;
    }

    @Override
    protected Object visit(ASTMapLiteral node, Object data) {
        int num = node.jjtGetNumChildren();
        this.builder.append("{ ");
        if (num > 0) {
            if (this.depth <= 0) {
                this.builder.append("...");
            } else {
                this.accept(node.jjtGetChild(0), data);
                for (int i = 1; i < num; ++i) {
                    this.builder.append(",");
                    this.accept(node.jjtGetChild(i), data);
                }
            }
        } else {
            this.builder.append(':');
        }
        this.builder.append(" }");
        return data;
    }

    @Override
    protected Object visit(ASTMethodNode node, Object data) {
        int num = node.jjtGetNumChildren();
        if (num == 2) {
            this.accept(node.jjtGetChild(0), data);
            if (this.depth <= 0) {
                this.builder.append("(...)");
            } else {
                this.accept(node.jjtGetChild(1), data);
            }
        }
        return data;
    }

    @Override
    protected Object visit(ASTModNode node, Object data) {
        return this.infixChildren(node, " % ", false, data);
    }

    @Override
    protected Object visit(ASTMulNode node, Object data) {
        return this.infixChildren(node, " * ", false, data);
    }

    @Override
    protected Object visit(ASTNENode node, Object data) {
        return this.infixChildren(node, " != ", false, data);
    }

    @Override
    protected Object visit(ASTNESNode node, Object data) {
        return this.infixChildren(node, " !== ", false, data);
    }

    @Override
    protected Object visit(ASTNEWNode node, Object data) {
        return this.infixChildren(node, " !$ ", false, data);
    }

    @Override
    protected Object visit(ASTNotInstanceOf node, Object data) {
        return this.infixChildren(node, " !instanceof ", false, data);
    }

    @Override
    protected Object visit(ASTNotNode node, Object data) {
        this.builder.append("!");
        this.accept(node.jjtGetChild(0), data);
        return data;
    }

    @Override
    protected Object visit(ASTNRNode node, Object data) {
        return this.infixChildren(node, " !~ ", false, data);
    }

    @Override
    protected Object visit(ASTNSWNode node, Object data) {
        return this.infixChildren(node, " !^ ", false, data);
    }

    @Override
    protected Object visit(ASTNullLiteral node, Object data) {
        this.check(node, "null", data);
        return data;
    }

    @Override
    protected Object visit(ASTNullpNode node, Object data) {
        this.accept(node.jjtGetChild(0), data);
        this.builder.append("??");
        this.accept(node.jjtGetChild(1), data);
        return data;
    }

    @Override
    protected Object visit(ASTNumberLiteral node, Object data) {
        return this.check(node, node.toString(), data);
    }

    @Override
    protected Object visit(ASTOrNode node, Object data) {
        boolean paren = node.jjtGetParent() instanceof ASTAndNode;
        return this.infixChildren(node, " || ", paren, data);
    }

    @Override
    protected Object visit(ASTQualifiedIdentifier node, Object data) {
        String img = node.getName();
        return this.check(node, img, data);
    }

    @Override
    protected Object visit(ASTRangeNode node, Object data) {
        if (this.depth <= 0) {
            this.builder.append("( .. )");
            return data;
        }
        return this.infixChildren(node, " .. ", false, data);
    }

    @Override
    protected Object visit(ASTReference node, Object data) {
        int num = node.jjtGetNumChildren();
        for (int i = 0; i < num; ++i) {
            this.accept(node.jjtGetChild(i), data);
        }
        return data;
    }

    @Override
    protected Object visit(ASTReferenceExpression node, Object data) {
        JexlNode first = node.jjtGetChild(0);
        this.builder.append('(');
        this.accept(first, data);
        this.builder.append(')');
        int num = node.jjtGetNumChildren();
        for (int i = 1; i < num; ++i) {
            this.builder.append("[");
            this.accept(node.jjtGetChild(i), data);
            this.builder.append("]");
        }
        return data;
    }

    @Override
    protected Object visit(ASTRegexLiteral node, Object data) {
        String img = StringParser.escapeString(node.toString(), '/');
        return this.check(node, "~" + img, data);
    }

    @Override
    protected Object visit(ASTReturnStatement node, Object data) {
        this.builder.append("return ");
        this.accept(node.jjtGetChild(0), data);
        return data;
    }

    @Override
    protected Object visit(ASTSetAddNode node, Object data) {
        return this.infixChildren(node, " += ", false, data);
    }

    @Override
    protected Object visit(ASTSetAndNode node, Object data) {
        return this.infixChildren(node, " &= ", false, data);
    }

    @Override
    protected Object visit(ASTSetDivNode node, Object data) {
        return this.infixChildren(node, " /= ", false, data);
    }

    @Override
    protected Object visit(ASTSetLiteral node, Object data) {
        int num = node.jjtGetNumChildren();
        this.builder.append("{ ");
        if (num > 0) {
            if (this.depth <= 0) {
                this.builder.append("...");
            } else {
                this.accept(node.jjtGetChild(0), data);
                for (int i = 1; i < num; ++i) {
                    this.builder.append(",");
                    this.accept(node.jjtGetChild(i), data);
                }
            }
        }
        this.builder.append(" }");
        return data;
    }

    @Override
    protected Object visit(ASTSetModNode node, Object data) {
        return this.infixChildren(node, " %= ", false, data);
    }

    @Override
    protected Object visit(ASTSetMultNode node, Object data) {
        return this.infixChildren(node, " *= ", false, data);
    }

    @Override
    protected Object visit(ASTSetOrNode node, Object data) {
        return this.infixChildren(node, " |= ", false, data);
    }

    @Override
    protected Object visit(ASTSetShiftLeftNode node, Object data) {
        return this.infixChildren(node, " <<= ", false, data);
    }

    @Override
    protected Object visit(ASTSetShiftRightNode node, Object data) {
        return this.infixChildren(node, " >>= ", false, data);
    }

    @Override
    protected Object visit(ASTSetShiftRightUnsignedNode node, Object data) {
        return this.infixChildren(node, " >>>= ", false, data);
    }

    @Override
    protected Object visit(ASTSetSubNode node, Object data) {
        return this.infixChildren(node, " -= ", false, data);
    }

    @Override
    protected Object visit(ASTSetXorNode node, Object data) {
        return this.infixChildren(node, " ^= ", false, data);
    }

    @Override
    protected Object visit(ASTShiftLeftNode node, Object data) {
        return this.infixChildren(node, " << ", false, data);
    }

    @Override
    protected Object visit(ASTShiftRightNode node, Object data) {
        return this.infixChildren(node, " >> ", false, data);
    }

    @Override
    protected Object visit(ASTShiftRightUnsignedNode node, Object data) {
        return this.infixChildren(node, " >>> ", false, data);
    }

    @Override
    protected Object visit(ASTSizeFunction node, Object data) {
        this.builder.append("size ");
        this.accept(node.jjtGetChild(0), data);
        return data;
    }

    @Override
    protected Object visit(ASTStringLiteral node, Object data) {
        String img = StringParser.escapeString(node.getLiteral(), '\'');
        return this.check(node, img, data);
    }

    @Override
    protected Object visit(ASTSubNode node, Object data) {
        return this.additiveNode(node, " - ", data);
    }

    @Override
    protected Object visit(ASTSWNode node, Object data) {
        return this.infixChildren(node, " =^ ", false, data);
    }

    @Override
    protected Object visit(ASTTernaryNode node, Object data) {
        this.accept(node.jjtGetChild(0), data);
        if (node.jjtGetNumChildren() > 2) {
            this.builder.append("? ");
            this.accept(node.jjtGetChild(1), data);
            this.builder.append(" : ");
            this.accept(node.jjtGetChild(2), data);
        } else {
            this.builder.append("?: ");
            this.accept(node.jjtGetChild(1), data);
        }
        return data;
    }

    @Override
    protected Object visit(ASTThrowStatement node, Object data) {
        this.builder.append("throw ");
        this.accept(node.jjtGetChild(0), data);
        return data;
    }

    @Override
    protected Object visit(ASTTrueNode node, Object data) {
        this.check(node, "true", data);
        return data;
    }

    @Override
    protected Object visit(ASTTryResources node, Object data) {
        int tryBody = node.jjtGetNumChildren() - 1;
        this.builder.append('(');
        this.accept(node.jjtGetChild(0), data);
        for (int c = 1; c < tryBody; ++c) {
            this.builder.append("; ");
            this.accept(node.jjtGetChild(c), data);
        }
        this.builder.append(") ");
        this.accept(node.jjtGetChild(tryBody), data);
        return data;
    }

    @Override
    protected Object visit(ASTTryStatement node, Object data) {
        this.builder.append("try");
        int nc = 0;
        this.accept(node.jjtGetChild(nc++), data);
        if (node.hasCatchClause()) {
            this.builder.append("catch(");
            this.accept(node.jjtGetChild(nc++), data);
            this.builder.append(") ");
            this.accept(node.jjtGetChild(nc++), data);
        }
        if (node.hasFinallyClause()) {
            this.builder.append(this.indent > 0 ? this.lf : Character.valueOf(' '));
            this.builder.append("finally ");
            this.accept(node.jjtGetChild(nc), data);
        }
        return data;
    }

    @Override
    protected Object visit(ASTUnaryMinusNode node, Object data) {
        return this.prefixChild(node, "-", data);
    }

    @Override
    protected Object visit(ASTUnaryPlusNode node, Object data) {
        return this.prefixChild(node, "+", data);
    }

    @Override
    protected Object visit(ASTVar node, Object data) {
        if (node.isConstant()) {
            this.builder.append("const ");
        } else if (node.isLexical()) {
            this.builder.append("let ");
        } else {
            this.builder.append("var ");
        }
        this.check(node, node.getName(), data);
        return data;
    }

    @Override
    protected Object visit(ASTWhileStatement node, Object data) {
        this.builder.append("while (");
        this.accept(node.jjtGetChild(0), data);
        this.builder.append(") ");
        if (node.jjtGetNumChildren() > 1) {
            this.acceptStatement(node.jjtGetChild(1), data);
        } else {
            this.builder.append(';');
        }
        return data;
    }

    protected String visitParameter(String p, Object data) {
        return p;
    }
}

