/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.libraries.commons.jexl3.internal;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.william278.velocitab.libraries.commons.jexl3.JexlArithmetic;
import net.william278.velocitab.libraries.commons.jexl3.JexlEngine;
import net.william278.velocitab.libraries.commons.jexl3.JexlException;
import net.william278.velocitab.libraries.commons.jexl3.JexlOperator;
import net.william278.velocitab.libraries.commons.jexl3.internal.InterpreterBase;
import net.william278.velocitab.libraries.commons.jexl3.internal.introspection.MethodExecutor;
import net.william278.velocitab.libraries.commons.jexl3.introspection.JexlMethod;
import net.william278.velocitab.libraries.commons.jexl3.introspection.JexlUberspect;
import net.william278.velocitab.libraries.commons.jexl3.parser.JexlNode;

public class Operators {
    protected final InterpreterBase interpreter;
    protected final JexlArithmetic.Uberspect operators;

    private static boolean isPostfix(JexlOperator operator) {
        return operator == JexlOperator.GET_AND_INCREMENT || operator == JexlOperator.GET_AND_DECREMENT;
    }

    protected Operators(InterpreterBase owner) {
        JexlArithmetic arithmetic = owner.arithmetic;
        JexlUberspect uberspect = owner.uberspect;
        this.interpreter = owner;
        this.operators = uberspect.getArithmetic(arithmetic);
    }

    private Object[] arguments(JexlOperator operator, Object ... args) {
        Object[] objectArray;
        if (operator.getArity() == 1 && args.length > 1) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = args[0];
        } else {
            objectArray = args;
        }
        return objectArray;
    }

    protected boolean contains(JexlNode node, String op, Object left, Object right) {
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        JexlUberspect uberspect = this.interpreter.uberspect;
        try {
            Object result = this.tryOverload(node, JexlOperator.CONTAINS, left, right);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            Boolean matched = arithmetic.contains(left, right);
            if (matched != null) {
                return matched;
            }
            try {
                Object[] argv = new Object[]{right};
                JexlMethod vm = uberspect.getMethod(left, "contains", argv);
                if (this.returnsBoolean(vm)) {
                    return (Boolean)vm.invoke(left, argv);
                }
                if (arithmetic.narrowArguments(argv) && this.returnsBoolean(vm = uberspect.getMethod(left, "contains", argv))) {
                    return (Boolean)vm.invoke(left, argv);
                }
            }
            catch (Exception e) {
                throw new JexlException(node, op + " error", (Throwable)e);
            }
            return arithmetic.equals(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, op + " error", (Throwable)xrt);
        }
    }

    protected void controlNullOperands(JexlArithmetic arithmetic, JexlOperator operator, Object ... args) {
        for (Object arg : args) {
            if (arg != null) continue;
            if (!arithmetic.isStrict(operator)) break;
            throw new JexlArithmetic.NullOperand();
        }
    }

    protected Object empty(JexlNode node, Object object) {
        if (object == null) {
            return true;
        }
        Object result = this.tryOverload(node, JexlOperator.EMPTY, object);
        if (result != JexlEngine.TRY_FAILED) {
            return result;
        }
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        result = arithmetic.isEmpty(object, null);
        if (result == null) {
            JexlUberspect uberspect = this.interpreter.uberspect;
            result = false;
            JexlMethod vm = uberspect.getMethod(object, "isEmpty", InterpreterBase.EMPTY_PARAMS);
            if (this.returnsBoolean(vm)) {
                try {
                    result = vm.invoke(object, InterpreterBase.EMPTY_PARAMS);
                }
                catch (Exception xany) {
                    this.interpreter.operatorError(node, JexlOperator.EMPTY, xany);
                }
            }
        }
        return !(result instanceof Boolean) || (Boolean)result != false;
    }

    protected boolean endsWith(JexlNode node, String operator, Object left, Object right) {
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        JexlUberspect uberspect = this.interpreter.uberspect;
        try {
            Object result = this.tryOverload(node, JexlOperator.ENDSWITH, left, right);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            Boolean matched = arithmetic.endsWith(left, right);
            if (matched != null) {
                return matched;
            }
            try {
                Object[] argv = new Object[]{right};
                JexlMethod vm = uberspect.getMethod(left, "endsWith", argv);
                if (this.returnsBoolean(vm)) {
                    return (Boolean)vm.invoke(left, argv);
                }
                if (arithmetic.narrowArguments(argv) && this.returnsBoolean(vm = uberspect.getMethod(left, "endsWith", argv))) {
                    return (Boolean)vm.invoke(left, argv);
                }
            }
            catch (Exception e) {
                throw new JexlException(node, operator + " error", (Throwable)e);
            }
            return arithmetic.equals(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, operator + " error", (Throwable)xrt);
        }
    }

    private boolean isArithmetic(JexlMethod vm) {
        if (vm instanceof MethodExecutor) {
            Method method = ((MethodExecutor)vm).getMethod();
            return JexlArithmetic.class.equals(method.getDeclaringClass());
        }
        return false;
    }

    private boolean returnsBoolean(JexlMethod vm) {
        if (vm != null) {
            Class<?> rc = vm.getReturnType();
            return Boolean.TYPE.equals(rc) || Boolean.class.equals(rc);
        }
        return false;
    }

    private boolean returnsInteger(JexlMethod vm) {
        if (vm != null) {
            Class<?> rc = vm.getReturnType();
            return Integer.TYPE.equals(rc) || Integer.class.equals(rc);
        }
        return false;
    }

    protected Object size(JexlNode node, Object object) {
        JexlUberspect uberspect;
        JexlMethod vm;
        if (object == null) {
            return 0;
        }
        Object result = this.tryOverload(node, JexlOperator.SIZE, object);
        if (result != JexlEngine.TRY_FAILED) {
            return result;
        }
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        result = arithmetic.size(object, null);
        if (result == null && this.returnsInteger(vm = (uberspect = this.interpreter.uberspect).getMethod(object, "size", InterpreterBase.EMPTY_PARAMS))) {
            try {
                result = vm.invoke(object, InterpreterBase.EMPTY_PARAMS);
            }
            catch (Exception xany) {
                this.interpreter.operatorError(node, JexlOperator.SIZE, xany);
            }
        }
        return result instanceof Number ? ((Number)result).intValue() : 0;
    }

    protected boolean startsWith(JexlNode node, String operator, Object left, Object right) {
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        JexlUberspect uberspect = this.interpreter.uberspect;
        try {
            Object result = this.tryOverload(node, JexlOperator.STARTSWITH, left, right);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            Boolean matched = arithmetic.startsWith(left, right);
            if (matched != null) {
                return matched;
            }
            try {
                Object[] argv = new Object[]{right};
                JexlMethod vm = uberspect.getMethod(left, "startsWith", argv);
                if (this.returnsBoolean(vm)) {
                    return (Boolean)vm.invoke(left, argv);
                }
                if (arithmetic.narrowArguments(argv) && this.returnsBoolean(vm = uberspect.getMethod(left, "startsWith", argv))) {
                    return (Boolean)vm.invoke(left, argv);
                }
            }
            catch (Exception e) {
                throw new JexlException(node, operator + " error", (Throwable)e);
            }
            return arithmetic.equals(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, operator + " error", (Throwable)xrt);
        }
    }

    protected Object tryAssignOverload(JexlNode node, JexlOperator operator, Consumer<Object> assignFun, Object ... args) {
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        if (args.length < operator.getArity()) {
            return JexlEngine.TRY_FAILED;
        }
        try {
            Object result;
            if (this.operators != null) {
                result = this.tryOverload(node, operator, this.arguments(operator, args));
                if (result != JexlEngine.TRY_FAILED) {
                    return result;
                }
                JexlOperator base = operator.getBaseOperator();
                if (base != null && this.operators.overloads(base) && (result = this.tryOverload(node, base, this.arguments(base, args))) != JexlEngine.TRY_FAILED) {
                    assignFun.accept(result);
                    return Operators.isPostfix(operator) ? args[0] : result;
                }
            }
            switch (operator) {
                case SELF_ADD: {
                    result = arithmetic.add(args[0], args[1]);
                    break;
                }
                case SELF_SUBTRACT: {
                    result = arithmetic.subtract(args[0], args[1]);
                    break;
                }
                case SELF_MULTIPLY: {
                    result = arithmetic.multiply(args[0], args[1]);
                    break;
                }
                case SELF_DIVIDE: {
                    result = arithmetic.divide(args[0], args[1]);
                    break;
                }
                case SELF_MOD: {
                    result = arithmetic.mod(args[0], args[1]);
                    break;
                }
                case SELF_AND: {
                    result = arithmetic.and(args[0], args[1]);
                    break;
                }
                case SELF_OR: {
                    result = arithmetic.or(args[0], args[1]);
                    break;
                }
                case SELF_XOR: {
                    result = arithmetic.xor(args[0], args[1]);
                    break;
                }
                case SELF_SHIFTLEFT: {
                    result = arithmetic.shiftLeft(args[0], args[1]);
                    break;
                }
                case SELF_SHIFTRIGHT: {
                    result = arithmetic.shiftRight(args[0], args[1]);
                    break;
                }
                case SELF_SHIFTRIGHTU: {
                    result = arithmetic.shiftRightUnsigned(args[0], args[1]);
                    break;
                }
                case INCREMENT_AND_GET: {
                    result = arithmetic.increment(args[0]);
                    break;
                }
                case DECREMENT_AND_GET: {
                    result = arithmetic.decrement(args[0]);
                    break;
                }
                case GET_AND_INCREMENT: {
                    result = args[0];
                    assignFun.accept(arithmetic.increment(result));
                    return result;
                }
                case GET_AND_DECREMENT: {
                    result = args[0];
                    assignFun.accept(arithmetic.decrement(result));
                    return result;
                }
                default: {
                    throw new UnsupportedOperationException(operator.getOperatorSymbol());
                }
            }
            assignFun.accept(result);
            return result;
        }
        catch (Exception xany) {
            this.interpreter.operatorError(node, operator, xany);
            return JexlEngine.TRY_FAILED;
        }
    }

    protected Object tryOverload(JexlNode node, JexlOperator operator, Object ... args) {
        JexlArithmetic arithmetic = this.interpreter.arithmetic;
        this.controlNullOperands(arithmetic, operator, args);
        if (this.operators != null && this.operators.overloads(operator)) {
            boolean cache = this.interpreter.cache;
            try {
                Object eval;
                JexlMethod me;
                Object cached;
                if (cache && (cached = node.jjtGetValue()) instanceof JexlMethod && !(me = (JexlMethod)cached).tryFailed(eval = me.tryInvoke(operator.getMethodName(), arithmetic, args))) {
                    return eval;
                }
                JexlMethod vm = this.operators.getOperator(operator, args);
                if (vm != null && !this.isArithmetic(vm)) {
                    Object result = vm.invoke(arithmetic, args);
                    if (cache && !vm.tryFailed(result)) {
                        node.jjtSetValue(vm);
                    }
                    return result;
                }
            }
            catch (Exception xany) {
                this.interpreter.operatorError(node, operator, xany);
            }
        }
        return JexlEngine.TRY_FAILED;
    }
}

