/*
 * Decompiled with CFR 0.152.
 */
package net.william278.velocitab.packet;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.william278.velocitab.Velocitab;
import net.william278.velocitab.config.Group;
import net.william278.velocitab.libraries.annotations.NotNull;
import net.william278.velocitab.packet.PacketRegistration;
import net.william278.velocitab.packet.Protocol404Adapter;
import net.william278.velocitab.packet.Protocol48Adapter;
import net.william278.velocitab.packet.Protocol735Adapter;
import net.william278.velocitab.packet.Protocol765Adapter;
import net.william278.velocitab.packet.TeamsPacketAdapter;
import net.william278.velocitab.packet.UpdateTeamsPacket;
import net.william278.velocitab.player.TabPlayer;
import net.william278.velocitab.tab.Nametag;
import org.slf4j.event.Level;

public class ScoreboardManager {
    private PacketRegistration<UpdateTeamsPacket> packetRegistration;
    private final Velocitab plugin;
    private final Set<TeamsPacketAdapter> versions;
    private final Map<UUID, String> createdTeams;
    private final Map<String, Nametag> nametags;
    private final Multimap<UUID, String> trackedTeams;

    public ScoreboardManager(@NotNull Velocitab velocitab) {
        this.plugin = velocitab;
        this.createdTeams = Maps.newConcurrentMap();
        this.nametags = Maps.newConcurrentMap();
        this.versions = Sets.newHashSet();
        this.trackedTeams = Multimaps.synchronizedMultimap((Multimap)Multimaps.newSetMultimap((Map)Maps.newConcurrentMap(), Sets::newConcurrentHashSet));
        this.registerVersions();
    }

    private void registerVersions() {
        try {
            this.versions.add(new Protocol765Adapter(this.plugin));
            this.versions.add(new Protocol735Adapter(this.plugin));
            this.versions.add(new Protocol404Adapter(this.plugin));
            this.versions.add(new Protocol48Adapter(this.plugin));
        }
        catch (NoSuchFieldError e) {
            throw new IllegalStateException("Failed to register Scoreboard Teams packets. Velocitab probably does not (yet) support your Proxy version.", e);
        }
    }

    public boolean isInternalTeam(@NotNull String teamName) {
        return this.nametags.containsKey(teamName);
    }

    @NotNull
    public TeamsPacketAdapter getPacketAdapter(@NotNull ProtocolVersion version) {
        return this.versions.stream().filter(adapter -> adapter.getProtocolVersions().contains(version)).findFirst().orElseThrow(() -> new IllegalArgumentException("No adapter found for protocol version " + version));
    }

    public void close() {
        this.plugin.getServer().getAllPlayers().forEach(this::resetCache);
    }

    public void resetCache(@NotNull Player player) {
        String team = this.createdTeams.remove(player.getUniqueId());
        if (team != null) {
            this.plugin.getTabList().getTabPlayer(player).ifPresent(tabPlayer -> this.dispatchGroupPacket(UpdateTeamsPacket.removeTeam(this.plugin, team), (TabPlayer)tabPlayer));
            this.trackedTeams.removeAll((Object)player.getUniqueId());
        }
    }

    public void resetCache(@NotNull Player player, @NotNull Group group) {
        String team = this.createdTeams.remove(player.getUniqueId());
        if (team != null) {
            this.dispatchGroupPacket(UpdateTeamsPacket.removeTeam(this.plugin, team), group);
        }
    }

    public void vanishPlayer(@NotNull TabPlayer tabPlayer) {
        this.handleVanish(tabPlayer, true);
    }

    public void unVanishPlayer(@NotNull TabPlayer tabPlayer) {
        this.handleVanish(tabPlayer, false);
    }

    private void handleVanish(@NotNull TabPlayer tabPlayer, boolean vanish) {
        if (!this.plugin.getSettings().isSortPlayers()) {
            return;
        }
        Player player = tabPlayer.getPlayer();
        String teamName = this.createdTeams.get(player.getUniqueId());
        if (teamName == null) {
            return;
        }
        Set<RegisteredServer> siblings = tabPlayer.getGroup().registeredServers(this.plugin);
        Optional<Nametag> cachedTag = Optional.ofNullable(this.nametags.getOrDefault(teamName, null));
        cachedTag.ifPresent(nametag -> siblings.forEach(server -> server.getPlayersConnected().stream().filter(p -> p != player).forEach(connected -> {
            if (vanish && !this.plugin.getVanishManager().canSee(connected.getUsername(), player.getUsername())) {
                this.dispatchPacket(UpdateTeamsPacket.removeTeam(this.plugin, teamName), (Player)connected);
                this.trackedTeams.remove((Object)connected.getUniqueId(), (Object)teamName);
            } else {
                this.dispatchGroupCreatePacket(this.plugin, tabPlayer, teamName, (Nametag)nametag, player.getUsername());
            }
        })));
    }

    public void updateRole(@NotNull TabPlayer tabPlayer, @NotNull String role, boolean force) {
        Player player = tabPlayer.getPlayer();
        if (!player.isActive()) {
            this.plugin.getTabList().removeOfflinePlayer(player);
            return;
        }
        String name = player.getUsername();
        ((CompletableFuture)tabPlayer.getNametag(this.plugin).thenAccept(newTag -> {
            if (!this.createdTeams.getOrDefault(player.getUniqueId(), "").equals(role)) {
                if (this.createdTeams.containsKey(player.getUniqueId())) {
                    this.dispatchGroupPacket(UpdateTeamsPacket.removeTeam(this.plugin, this.createdTeams.get(player.getUniqueId())), tabPlayer);
                }
                this.createdTeams.put(player.getUniqueId(), role);
                this.nametags.put(role, (Nametag)newTag);
                this.dispatchGroupCreatePacket(this.plugin, tabPlayer, role, (Nametag)newTag, name);
            } else if (force || this.nametags.containsKey(role) && !this.nametags.get(role).equals(newTag)) {
                this.nametags.put(role, (Nametag)newTag);
                this.dispatchGroupChangePacket(this.plugin, tabPlayer, role, (Nametag)newTag);
            } else {
                this.updatePlaceholders(tabPlayer);
            }
        })).exceptionally(e -> {
            this.plugin.log(Level.ERROR, "Failed to update role for " + player.getUsername(), (Throwable)e);
            return null;
        });
    }

    public void updatePlaceholders(@NotNull TabPlayer tabPlayer) {
        Player player = tabPlayer.getPlayer();
        String role = this.createdTeams.get(player.getUniqueId());
        if (role == null) {
            return;
        }
        Optional<Nametag> optionalNametag = Optional.ofNullable(this.nametags.get(role));
        optionalNametag.ifPresent(nametag -> this.dispatchGroupChangePacket(this.plugin, tabPlayer, role, (Nametag)nametag));
    }

    public void resendAllTeams(@NotNull TabPlayer tabPlayer) {
        if (!this.plugin.getSettings().isSendScoreboardPackets()) {
            return;
        }
        Player player = tabPlayer.getPlayer();
        Set<Player> players = tabPlayer.getGroup().getPlayers(this.plugin, tabPlayer);
        HashSet roles = Sets.newHashSet();
        players.forEach(p -> {
            if (p == player || !p.isActive()) {
                return;
            }
            if (!this.plugin.getVanishManager().canSee(player.getUsername(), p.getUsername())) {
                return;
            }
            String role = this.createdTeams.getOrDefault(p.getUniqueId(), "");
            if (role.isEmpty()) {
                return;
            }
            Optional<TabPlayer> optionalTabPlayer = this.plugin.getTabList().getTabPlayer((Player)p);
            if (optionalTabPlayer.isEmpty()) {
                return;
            }
            TabPlayer targetTabPlayer = optionalTabPlayer.get();
            if (roles.contains(role)) {
                return;
            }
            roles.add(role);
            Nametag tag = this.nametags.get(role);
            if (tag != null) {
                this.dispatchCreatePacket(this.plugin, targetTabPlayer, role, tag, tabPlayer, p.getUsername());
            }
        });
    }

    private void dispatchGroupCreatePacket(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer, @NotNull String teamName, @NotNull Nametag nametag, String ... teamMembers) {
        tabPlayer.getGroup().getTabPlayers(plugin, tabPlayer).forEach(viewer -> {
            if (!viewer.getPlayer().isActive()) {
                return;
            }
            this.dispatchCreatePacket(plugin, tabPlayer, teamName, nametag, (TabPlayer)viewer, teamMembers);
        });
    }

    private void dispatchCreatePacket(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer, @NotNull String teamName, @NotNull Nametag nametag, @NotNull TabPlayer viewer, String ... teamMembers) {
        boolean canSee = plugin.getVanishManager().canSee(viewer.getPlayer().getUsername(), tabPlayer.getPlayer().getUsername());
        if (!canSee) {
            return;
        }
        UpdateTeamsPacket packet = UpdateTeamsPacket.create(plugin, tabPlayer, teamName, nametag, viewer, teamMembers);
        this.trackedTeams.put((Object)viewer.getPlayer().getUniqueId(), (Object)teamName);
        this.dispatchPacket(packet, viewer.getPlayer());
    }

    private void dispatchGroupChangePacket(@NotNull Velocitab plugin, @NotNull TabPlayer tabPlayer, @NotNull String teamName, @NotNull Nametag nametag) {
        tabPlayer.getGroup().getTabPlayers(plugin, tabPlayer).forEach(viewer -> {
            if (viewer == tabPlayer || !viewer.getPlayer().isActive()) {
                return;
            }
            boolean canSee = plugin.getVanishManager().canSee(viewer.getPlayer().getUsername(), tabPlayer.getPlayer().getUsername());
            if (!canSee) {
                return;
            }
            if (!this.trackedTeams.containsEntry((Object)viewer.getPlayer().getUniqueId(), (Object)teamName)) {
                return;
            }
            UpdateTeamsPacket packet = UpdateTeamsPacket.changeNametag(plugin, tabPlayer, teamName, viewer, nametag);
            Component prefix = packet.prefix();
            Component suffix = packet.suffix();
            Optional<Component[]> cached = tabPlayer.getRelationalNametag(viewer.getPlayer().getUniqueId());
            if (cached.isPresent() && cached.get()[0].equals(prefix) && cached.get()[1].equals(suffix)) {
                return;
            }
            tabPlayer.setRelationalNametag(viewer.getPlayer().getUniqueId(), prefix, suffix);
            this.dispatchPacket(packet, viewer.getPlayer());
        });
    }

    private void dispatchPacket(@NotNull UpdateTeamsPacket packet, @NotNull Player player) {
        if (!player.isActive()) {
            this.plugin.getTabList().removeOfflinePlayer(player);
            return;
        }
        try {
            ConnectedPlayer connectedPlayer = (ConnectedPlayer)player;
            connectedPlayer.getConnection().write((Object)packet);
        }
        catch (Throwable e) {
            this.plugin.log(Level.ERROR, "Failed to dispatch packet (unsupported client or server version)", e);
        }
    }

    private void dispatchGroupPacket(@NotNull UpdateTeamsPacket packet, @NotNull Group group) {
        boolean isRemove = packet.isRemoveTeam();
        group.registeredServers(this.plugin).forEach(server -> server.getPlayersConnected().forEach(connected -> {
            try {
                ConnectedPlayer connectedPlayer = (ConnectedPlayer)connected;
                connectedPlayer.getConnection().write((Object)packet);
                if (isRemove) {
                    this.trackedTeams.remove((Object)connected.getUniqueId(), (Object)packet.teamName());
                }
            }
            catch (Throwable e) {
                this.plugin.log(Level.ERROR, "Failed to dispatch packet (unsupported client or server version)", e);
            }
        }));
    }

    private void dispatchGroupPacket(@NotNull UpdateTeamsPacket packet, @NotNull TabPlayer tabPlayer) {
        Player player = tabPlayer.getPlayer();
        Optional optionalServerConnection = player.getCurrentServer();
        if (optionalServerConnection.isEmpty()) {
            return;
        }
        Set<Player> players = tabPlayer.getGroup().getPlayers(this.plugin);
        players.forEach(connected -> {
            try {
                boolean canSee = this.plugin.getVanishManager().canSee(connected.getUsername(), player.getUsername());
                if (!canSee) {
                    return;
                }
                ConnectedPlayer connectedPlayer = (ConnectedPlayer)connected;
                connectedPlayer.getConnection().write((Object)packet);
            }
            catch (Throwable e) {
                this.plugin.log(Level.ERROR, "Failed to dispatch packet (unsupported client or server version)", e);
            }
        });
    }

    public void registerPacket() {
        try {
            this.packetRegistration = PacketRegistration.of(UpdateTeamsPacket.class).direction(ProtocolUtils.Direction.CLIENTBOUND).packetSupplier(() -> new UpdateTeamsPacket(this.plugin)).stateRegistry(StateRegistry.PLAY).mapping(62, ProtocolVersion.MINECRAFT_1_8, false).mapping(68, ProtocolVersion.MINECRAFT_1_12_2, false).mapping(71, ProtocolVersion.MINECRAFT_1_13, false).mapping(75, ProtocolVersion.MINECRAFT_1_14, false).mapping(76, ProtocolVersion.MINECRAFT_1_15, false).mapping(85, ProtocolVersion.MINECRAFT_1_17, false).mapping(88, ProtocolVersion.MINECRAFT_1_19_1, false).mapping(86, ProtocolVersion.MINECRAFT_1_19_3, false).mapping(90, ProtocolVersion.MINECRAFT_1_19_4, false).mapping(92, ProtocolVersion.MINECRAFT_1_20_2, false).mapping(94, ProtocolVersion.MINECRAFT_1_20_3, false).mapping(96, ProtocolVersion.MINECRAFT_1_20_5, false);
            this.packetRegistration.register();
        }
        catch (Throwable e) {
            this.plugin.log(Level.ERROR, "Failed to register UpdateTeamsPacket", e);
        }
    }

    public void unregisterPacket() {
        if (this.packetRegistration == null) {
            return;
        }
        try {
            this.packetRegistration.unregister();
        }
        catch (Throwable e) {
            this.plugin.log(Level.ERROR, "Failed to unregister UpdateTeamsPacket", e);
        }
    }

    public void recalculateVanishForPlayer(TabPlayer tabPlayer, TabPlayer target, boolean canSee) {
        Nametag tag;
        Player player = tabPlayer.getPlayer();
        String team = this.createdTeams.get(target.getPlayer().getUniqueId());
        if (team == null) {
            return;
        }
        UpdateTeamsPacket removeTeam = UpdateTeamsPacket.removeTeam(this.plugin, team);
        this.dispatchPacket(removeTeam, player);
        this.trackedTeams.remove((Object)player.getUniqueId(), (Object)team);
        if (canSee && (tag = this.nametags.get(team)) != null) {
            this.dispatchCreatePacket(this.plugin, tabPlayer, team, tag, target, target.getPlayer().getUsername());
        }
    }
}

